/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.launcher.updater.RawVersionList;
import net.minecraft.launcher.updater.RemoteVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.PartialVersion;
import org.apache.commons.io.IOExceptionList;
import org.apache.http.client.fluent.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.tlauncher.repository.RepositoryProxy;
import ru.turikhay.util.EHttpClient;
import ru.turikhay.util.OS;
import ru.turikhay.util.Time;

public class OfficialVersionList
extends RemoteVersionList {
    private static final Logger LOGGER = LogManager.getLogger(OfficialVersionList.class);
    private static final String LAUNCHER_META_PREFIX = "https://launchermeta.mojang.com/mc/game/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawVersionList getRawList() throws IOException {
        URL ogUrl = new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json");
        ArrayList<String> urlCandidates = new ArrayList<String>();
        urlCandidates.add(ogUrl.toString());
        RepositoryProxy.getProxyRepoList().getRelevant().getList().stream().filter(r -> r instanceof RepositoryProxy.ProxyRepo).map(r -> ((RepositoryProxy.ProxyRepo)r).prefixUrl(ogUrl)).forEach(urlCandidates::add);
        ArrayList<IOException> ioEList = new ArrayList<IOException>(urlCandidates.size());
        for (String url : urlCandidates) {
            RawVersionList rawVersionList;
            String content;
            Object currentUrlLock = new Object();
            Time.start(currentUrlLock);
            LOGGER.debug("Fetching official repository: {}", (Object)url);
            try {
                content = EHttpClient.toString(Request.Get((String)url));
            }
            catch (IOException ioE) {
                LOGGER.warn("Official repository is not available: {}", (Object)url, (Object)ioE);
                ioEList.add(ioE);
                Time.stop(currentUrlLock);
                continue;
            }
            try {
                rawVersionList = Objects.requireNonNull((RawVersionList)this.gson.fromJson(content, RawVersionList.class));
            }
            catch (RuntimeException e) {
                LOGGER.warn("Couldn't parse official repository response: {}", (Object)content, (Object)e);
                ioEList.add(new IOException("invalid json", e));
                Time.stop(currentUrlLock);
                continue;
            }
            try {
                LOGGER.info("Got OfficialVersionList in {} ms", (Object)Time.stop(currentUrlLock));
                RawVersionList rawVersionList2 = this.process(rawVersionList);
                return rawVersionList2;
            }
            finally {
                Time.stop(currentUrlLock);
            }
        }
        LOGGER.warn("Official repository is not reachable");
        throw new IOExceptionList(ioEList);
    }

    private RawVersionList process(RawVersionList list) {
        for (PartialVersion version : list.versions) {
            version.setVersionList(this);
        }
        return list;
    }

    @Override
    public boolean hasAllFiles(CompleteVersion var1, OS var2) {
        return true;
    }

    @Override
    protected InputStreamReader getUrl(String var1) throws IOException {
        return Repository.PROXIFIED_REPO.read(LAUNCHER_META_PREFIX + var1);
    }
}

