/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.MalformedJsonException;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Set;
import net.minecraft.launcher.updater.StreamVersionList;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.CurrentLaunchFeatureMatcher;
import net.minecraft.launcher.versions.Version;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.pasta.Pasta;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.OS;

public class LocalVersionList
extends StreamVersionList {
    private static final Logger LOGGER = LogManager.getLogger(LocalVersionList.class);
    private final JsonParser jsonParser = new JsonParser();
    private File baseDirectory;
    private File baseVersionsDir;

    public LocalVersionList() throws IOException {
        this.setBaseDirectory(MinecraftUtil.getWorkingDirectory());
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File getVersionsDirectory() {
        return this.baseVersionsDir;
    }

    public void setBaseDirectory(File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Base directory is NULL!");
        }
        if (!directory.isDirectory()) {
            throw new IOException("Directory is not yet created!");
        }
        if (!directory.canWrite()) {
            throw new IOException("Directory is not accessible!");
        }
        this.baseDirectory = directory;
        this.baseVersionsDir = new File(this.baseDirectory, "versions");
    }

    @Override
    public synchronized void refreshVersions() throws IOException {
        File[] files;
        this.clearCache();
        if (!this.baseVersionsDir.isDirectory()) {
            FileUtil.createFolder(this.baseVersionsDir);
        }
        if ((files = this.baseVersionsDir.listFiles()) != null) {
            for (File directory : files) {
                String id = directory.getName();
                File jsonFile = new File(directory, id + ".json");
                if (!directory.isDirectory() || !jsonFile.isFile()) continue;
                String input = null;
                try {
                    try (InputStreamReader reader = this.getUrl("versions/" + id + "/" + id + ".json");){
                        input = IOUtils.toString((Reader)reader);
                    }
                    if (input.isEmpty()) {
                        LOGGER.warn("Json of {} is empty and is going to be deleted", (Object)id);
                        this.deleteJsonFile(id, jsonFile);
                        continue;
                    }
                    if (StringUtils.containsOnly((CharSequence)input, (char[])new char[]{'\u0000'})) {
                        LOGGER.warn("Json of {} is corrupted and contain only zero bytes. Will try to delete it", (Object)id);
                        this.deleteJsonFile(id, jsonFile);
                        continue;
                    }
                    JsonElement jsonElement = JsonParser.parseString((String)input);
                    if (!jsonElement.isJsonObject()) {
                        LOGGER.warn("Version doesn't contain object: {}", (Object)id);
                        continue;
                    }
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    if (jsonObject.has("modpack") && !jsonObject.get("modpack").isJsonPrimitive()) {
                        LOGGER.debug("Ignoring modpack version: {}", (Object)id);
                        continue;
                    }
                    if (!jsonObject.has("id")) {
                        LOGGER.warn("Ignored version without id: {} (probably not a Minecraft version at all)", (Object)id);
                        continue;
                    }
                    CompleteVersion ex = (CompleteVersion)this.gson.fromJson((JsonElement)jsonObject, CompleteVersion.class);
                    if (ex == null) {
                        LOGGER.warn("Version is empty: {}", (Object)id);
                        continue;
                    }
                    ex.setID(id);
                    ex.setSource(Repository.LOCAL_VERSION_REPO);
                    ex.setVersionList(this);
                    this.addVersion(ex);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof MalformedJsonException || e.getCause() instanceof EOFException) {
                        LOGGER.warn("Invalid json file {}", (Object)id, (Object)e);
                    } else {
                        LOGGER.warn("Could not parse local version \"{}\"", (Object)id, (Object)e);
                        Sentry.capture((EventBuilder)new EventBuilder().withMessage("couldn't parse local version").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withExtra("version", (Object)id).withExtra("input", (Object)Pasta.pasteJson(input)).withLevel(Event.Level.ERROR));
                    }
                    if (!(e instanceof JsonSyntaxException)) continue;
                    this.renameJsonFile(jsonFile);
                }
            }
        }
    }

    private void deleteJsonFile(String id, File jsonFile) {
        if (jsonFile.delete()) {
            LOGGER.warn("Json of {} deleted successfully", (Object)id);
        } else {
            LOGGER.error("Couldn't remove json of {}: {}", (Object)id, (Object)jsonFile.getAbsolutePath());
        }
    }

    private void renameJsonFile(File jsonFile) {
        String newName = jsonFile.getName() + ".invalid";
        LOGGER.info("Renaming json file: {} -> {}", (Object)jsonFile.getAbsolutePath(), (Object)newName);
        Path jsonFilePath = jsonFile.toPath();
        try {
            Files.move(jsonFilePath, jsonFilePath.resolveSibling(newName), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't rename {}", (Object)jsonFile.getAbsolutePath(), (Object)e);
        }
    }

    public void saveVersion(CompleteVersion version) throws IOException {
        String text = this.serializeVersion(version);
        File target = new File(this.baseVersionsDir, version.getID() + "/" + version.getID() + ".json");
        FileUtil.writeFile(target, text);
    }

    public synchronized void deleteVersion(String id, boolean deleteLibraries) throws IOException {
        CurrentLaunchFeatureMatcher featureMatcher = new CurrentLaunchFeatureMatcher();
        CompleteVersion version = this.getCompleteVersion(id);
        if (version == null) {
            throw new IllegalArgumentException("Version is not installed!");
        }
        File dir = new File(this.baseVersionsDir, id + '/');
        if (!dir.isDirectory()) {
            throw new IOException("Cannot find directory: " + dir.getAbsolutePath());
        }
        FileUtil.deleteDirectory(dir);
        if (deleteLibraries) {
            for (File nativeLib : version.getClassPath(featureMatcher, this.baseDirectory)) {
                FileUtil.deleteFile(nativeLib);
            }
            for (String nativeLib1 : version.getNatives(featureMatcher)) {
                FileUtil.deleteFile(new File(this.baseDirectory, nativeLib1));
            }
        }
    }

    @Override
    protected InputStream getInputStream(String uri) throws IOException {
        return new FileInputStream(new File(this.baseDirectory, uri));
    }

    @Override
    public boolean hasAllFiles(CompleteVersion version, OS os) {
        Set<String> files = version.getRequiredFiles(os, new CurrentLaunchFeatureMatcher());
        for (String filename : files) {
            File required = new File(this.baseDirectory, filename);
            if (required.isFile() && required.length() != 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized CompleteVersion getCompleteVersion(Version version) throws JsonSyntaxException, IOException {
        CompleteVersion complete;
        if (version instanceof CompleteVersion) {
            return (CompleteVersion)version;
        }
        if (version == null) {
            throw new NullPointerException("Version cannot be NULL!");
        }
        try (InputStreamReader reader = this.getUrl("versions/" + version.getID() + "/" + version.getID() + ".json");){
            complete = (CompleteVersion)this.gson.fromJson((Reader)reader, CompleteVersion.class);
        }
        complete.setID(version.getID());
        complete.setVersionList(this);
        Collections.replaceAll(this.versions, version, complete);
        return complete;
    }
}

