/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ru.turikhay.util.FileUtil;

public class AssetIndex {
    public static final String DEFAULT_ASSET_NAME = "pre-1.6";
    private final Map<String, AssetObject> objects = new LinkedHashMap<String, AssetObject>();
    private boolean virtual;
    public Boolean map_to_resources;

    public Map<String, AssetObject> getFileMap() {
        return this.objects;
    }

    public boolean isMapToResources() {
        return this.map_to_resources != null && this.map_to_resources != false;
    }

    public Set<AssetObject> getUniqueObjects() {
        return new HashSet<AssetObject>(this.objects.values());
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public static String getPath(String hash) {
        return hash.substring(0, 2) + "/" + hash;
    }

    public static String getHash(File file) {
        return FileUtil.getDigest(file, "SHA", 40);
    }

    public static class AssetObject {
        private String hash;
        private long size;
        private boolean reconstruct;
        private String compressedHash;
        private long compressedSize;

        public String hash() {
            return this.isCompressed() ? this.compressedHash : this.hash;
        }

        public long size() {
            return this.isCompressed() ? this.compressedSize : this.size;
        }

        public String getHash() {
            return this.hash;
        }

        public long getSize() {
            return this.size;
        }

        public boolean shouldReconstruct() {
            return this.reconstruct;
        }

        public boolean isCompressed() {
            return this.compressedHash != null;
        }

        public String getCompressedHash() {
            return this.compressedHash;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssetObject that = (AssetObject)o;
            if (this.compressedSize != that.compressedSize) {
                return false;
            }
            if (this.reconstruct != that.reconstruct) {
                return false;
            }
            if (this.size != that.size) {
                return false;
            }
            if (!Objects.equals(this.compressedHash, that.compressedHash)) {
                return false;
            }
            return Objects.equals(this.hash, that.hash);
        }

        public int hashCode() {
            int result = this.hash != null ? this.hash.hashCode() : 0;
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (this.reconstruct ? 1 : 0);
            result = 31 * result + (this.compressedHash != null ? this.compressedHash.hashCode() : 0);
            result = 31 * result + (int)(this.compressedSize ^ this.compressedSize >>> 32);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("compressed", this.isCompressed()).append("hash", (Object)(this.isCompressed() ? this.compressedHash : this.hash)).append("size", this.isCompressed() ? this.compressedSize : this.size).append("reconstruct", this.reconstruct).build();
        }
    }
}

