/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.updater;

import java.io.File;
import java.io.IOException;
import net.minecraft.launcher.updater.AssetIndex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.RetryDownloadException;
import ru.turikhay.tlauncher.managers.AssetsManager;
import ru.turikhay.tlauncher.repository.Repository;
import ru.turikhay.util.FileUtil;

public class AssetDownloadable
extends Downloadable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AssetIndex.AssetObject asset;
    private final File folder;

    public AssetDownloadable(AssetIndex.AssetObject obj, File objectsFolder) {
        this.asset = obj;
        this.folder = objectsFolder;
        String path = AssetIndex.getPath(this.asset.hash());
        this.setURL(Repository.ASSETS_REPO, path);
        this.setDestination(new File(this.folder, path));
    }

    @Override
    public void onComplete() throws RetryDownloadException {
        String gotHash;
        String expectHash = this.asset.hash();
        if (expectHash.equals(gotHash = FileUtil.getDigest(this.getDestination(), "SHA", 40))) {
            if (this.asset.isCompressed()) {
                try {
                    AssetsManager.decompress(this.getDestination(), new File(this.folder, this.asset.getHash()), this.asset.getHash());
                }
                catch (RetryDownloadException rdE) {
                    throw rdE;
                }
                catch (IOException ioE) {
                    throw new RetryDownloadException("could not decompress " + gotHash, ioE);
                }
            }
        } else {
            LOGGER.error("Invalid hash: {}; expected: {}", (Object)gotHash, (Object)expectHash);
            throw new RetryDownloadException(gotHash + ';' + expectHash);
        }
    }
}

