/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import net.minecraft.launcher.process.JavaProcess;
import net.minecraft.launcher.process.JavaProcessListener;
import net.minecraft.launcher.process.PrintStreamType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessMonitor {
    private final Logger LOGGER = LogManager.getLogger(ProcessMonitor.class);
    private final JavaProcess process;
    private final Charset charset;
    private final StreamMonitorWait wait;

    ProcessMonitor(JavaProcess process, Charset charset) {
        this.process = process;
        this.charset = charset;
        Process rawProcess = process.getRawProcess();
        StreamMonitorThread sysOut = new StreamMonitorThread(rawProcess.getInputStream(), PrintStreamType.OUT);
        StreamMonitorThread sysErr = new StreamMonitorThread(rawProcess.getErrorStream(), PrintStreamType.ERR);
        this.wait = new StreamMonitorWait(sysOut, sysErr);
    }

    public void start() {
        this.wait.start();
    }

    private class StreamMonitorThread
    extends Thread {
        private final InputStream inputStream;
        private final PrintStreamType streamType;

        public StreamMonitorThread(InputStream inputStream, PrintStreamType streamType) {
            super(StreamMonitorThread.class.getSimpleName() + "#" + streamType.name());
            this.inputStream = inputStream;
            this.streamType = streamType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (ProcessMonitor.this.process.isRunning()) {
                BufferedReader r = new BufferedReader(new InputStreamReader(this.inputStream, ProcessMonitor.this.charset));
                IOException suppressed = null;
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        JavaProcessListener listener = ProcessMonitor.this.process.getExitRunnable();
                        if (listener == null) {
                            ProcessMonitor.this.process.getSysOutLines().add(line);
                            continue;
                        }
                        listener.onJavaProcessPrint(ProcessMonitor.this.process, this.streamType, line);
                    }
                }
                catch (IOException ioE) {
                    suppressed = ioE;
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (IOException ioE) {
                        if (suppressed != null) {
                            ioE.addSuppressed(suppressed);
                        }
                        ProcessMonitor.this.LOGGER.warn("Error handling streams of {}", (Object)ProcessMonitor.this.process, (Object)ioE);
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    ProcessMonitor.this.LOGGER.warn("Interrupted");
                    return;
                }
            }
        }
    }

    private class StreamMonitorWait
    extends Thread {
        private final StreamMonitorThread sysOut;
        private final StreamMonitorThread sysErr;

        private StreamMonitorWait(StreamMonitorThread sysOut, StreamMonitorThread sysErr) {
            super(StreamMonitorWait.class.getSimpleName());
            this.sysOut = sysOut;
            this.sysErr = sysErr;
        }

        @Override
        public void run() {
            this.sysOut.start();
            this.sysErr.start();
            try {
                this.sysOut.join();
                this.sysErr.join();
            }
            catch (InterruptedException e) {
                ProcessMonitor.this.LOGGER.warn("{} was interrupted. Will not send JavaProcessEnd event", (Object)StreamMonitorWait.class.getSimpleName());
                return;
            }
            ProcessMonitor.this.process.getHook().processDestroyed(ProcessMonitor.this.process.getRawProcess());
            if (ProcessMonitor.this.process.getExitRunnable() != null) {
                ProcessMonitor.this.process.getExitRunnable().onJavaProcessEnded(ProcessMonitor.this.process);
            }
        }
    }
}

