/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.process.JavaProcess;
import ru.turikhay.tlauncher.minecraft.launcher.ProcessHook;
import ru.turikhay.util.OS;

public class JavaProcessLauncher {
    private final Charset charset;
    private final String jvmPath;
    private final List<String> commands;
    private File directory;
    private ProcessBuilder process;
    private ProcessHook hook = ProcessHook.None.INSTANCE;

    public JavaProcessLauncher(Charset charset, String jvmPath, String[] commands) {
        if (jvmPath == null) {
            jvmPath = OS.getJavaPath();
        }
        this.charset = charset;
        this.jvmPath = jvmPath;
        this.commands = new ArrayList<String>();
        Collections.addAll(this.commands, commands);
    }

    public String getJvmPath() {
        return this.jvmPath;
    }

    public JavaProcess start() throws IOException {
        return new JavaProcess(this.createProcess().start(), this.charset, this.hook);
    }

    public ProcessBuilder createProcess() {
        if (this.process == null) {
            this.process = new ProcessBuilder(this.getFullCommands()).directory(this.directory).redirectErrorStream(true);
            this.hook.enrichProcess(this.process);
        }
        return this.process;
    }

    List<String> getFullCommands() {
        ArrayList<String> result = new ArrayList<String>(this.commands.size() + 1);
        result.add(this.getJavaPath());
        result.addAll(this.commands);
        return result;
    }

    public String getCommandsAsString() {
        List<String> parts = this.getFullCommands();
        StringBuilder full = new StringBuilder();
        for (String part : parts) {
            if (full.length() != 0) {
                full.append(' ');
            }
            full.append(part);
        }
        return full.toString();
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void addCommand(Object command) {
        this.commands.add(command.toString());
    }

    public void addCommand(Object key, Object value) {
        this.commands.add(key.toString());
        this.commands.add(value.toString());
    }

    public void addCommands(Object[] commands) {
        for (Object c : commands) {
            this.commands.add(c.toString());
        }
    }

    public void addSplitCommands(Object commands) {
        this.addCommands(commands.toString().split(" "));
    }

    public ProcessHook getHook() {
        return this.hook;
    }

    public void addHook(ProcessHook hook) {
        if (this.process != null) {
            throw new IllegalStateException("Could not add hook after process being created");
        }
        this.hook = this.hook.then(hook);
    }

    public JavaProcessLauncher directory(File directory) {
        this.directory = directory;
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    String getJavaPath() {
        return this.jvmPath;
    }

    public String toString() {
        return "JavaProcessLauncher[commands=" + this.commands + ", java=" + this.jvmPath + "]";
    }
}

