/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.nio.charset.Charset;
import net.minecraft.launcher.process.JavaProcessListener;
import net.minecraft.launcher.process.LimitedCapacityList;
import net.minecraft.launcher.process.ProcessMonitor;
import ru.turikhay.tlauncher.minecraft.launcher.ProcessHook;

public class JavaProcess {
    private static final int MAX_SYSOUT_LINES = 5;
    private final LimitedCapacityList<String> sysOutLines = new LimitedCapacityList<String>(String.class, 5);
    private JavaProcessListener listener;
    private final Process process;
    private final ProcessMonitor monitor;
    private final Charset charset;
    private final ProcessHook hook;

    public JavaProcess(Process process, Charset charset, ProcessHook hook) {
        this.process = process;
        this.charset = charset;
        this.hook = hook;
        this.monitor = new ProcessMonitor(this, charset);
        this.monitor.start();
        hook.processCreated(process);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ProcessMonitor getMonitor() {
        return this.monitor;
    }

    public ProcessHook getHook() {
        return this.hook;
    }

    public Process getRawProcess() {
        return this.process;
    }

    public String getStartupCommand() {
        return this.process.toString();
    }

    public LimitedCapacityList<String> getSysOutLines() {
        return this.sysOutLines;
    }

    public boolean isRunning() {
        return this.process.isAlive();
    }

    public void setExitRunnable(JavaProcessListener runnable) {
        this.listener = runnable;
    }

    public void safeSetExitRunnable(JavaProcessListener runnable) {
        this.setExitRunnable(runnable);
        if (!this.isRunning() && runnable != null) {
            runnable.onJavaProcessEnded(this);
        }
    }

    public JavaProcessListener getExitRunnable() {
        return this.listener;
    }

    public int getExitCode() {
        try {
            return this.process.exitValue();
        }
        catch (IllegalThreadStateException var2) {
            var2.fillInStackTrace();
            throw var2;
        }
    }

    public String toString() {
        return "JavaProcess[process=" + this.process + ", isRunning=" + this.isRunning() + "]";
    }

    public void stop() {
        this.process.destroy();
    }
}

