/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.util.U;

public class Http {
    private static final Logger LOGGER = LogManager.getLogger();

    public static URL constantURL(String input) {
        try {
            return new URL(input);
        }
        catch (MalformedURLException var2) {
            throw new Error(var2);
        }
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("%3A", ":").replaceAll("%2F", "/").replaceAll("%21", "!").replaceAll("%27", "'").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%7E", "~");
        }
        catch (UnsupportedEncodingException var2) {
            throw new RuntimeException("UTF-8 is not supported.", var2);
        }
    }

    private static HttpURLConnection createUrlConnection(URL url) throws IOException {
        Validate.notNull((Object)url);
        LOGGER.trace("Opening connection to {}", (Object)url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(U.getProxy());
        connection.setConnectTimeout(U.getConnectionTimeout());
        connection.setReadTimeout(U.getReadTimeout());
        connection.setUseCaches(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String performPostRequest(URL url, String post, String contentType) throws IOException {
        String var10;
        Validate.notNull((Object)url);
        Validate.notNull((Object)post);
        Validate.notNull((Object)contentType);
        HttpURLConnection connection = Http.createUrlConnection(url);
        byte[] postAsBytes = post.getBytes(Charsets.UTF_8);
        connection.setRequestProperty("Content-Type", contentType + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
        connection.setDoOutput(true);
        LOGGER.trace("Writing POST data to {}: {}", (Object)url, (Object)post);
        OutputStream outputStream = null;
        try {
            outputStream = connection.getOutputStream();
            IOUtils.write((byte[])postAsBytes, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        LOGGER.trace("Reading data from {}", (Object)url);
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            String e = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            LOGGER.trace("Successful read, server response was {}", (Object)connection.getResponseCode());
            LOGGER.trace("Response: {}", (Object)e);
            var10 = e;
        }
        catch (IOException var18) {
            IOUtils.closeQuietly((InputStream)inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                LOGGER.error("Request to {} failed", (Object)url, (Object)var18);
                throw var18;
            }
            LOGGER.error("Reading error page from {}", (Object)url);
            String result = IOUtils.toString((InputStream)inputStream, (Charset)Charsets.UTF_8);
            LOGGER.error("Successful read, server response was {}", (Object)connection.getResponseCode());
            LOGGER.error("Response: {}", (Object)result);
            var10 = result;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return var10;
    }
}

