/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyTalents2;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.Talent;
import doggytalents.client.DogTextureManager;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.common.config.ConfigValues;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogModeData;
import doggytalents.common.network.packet.data.DogNameData;
import doggytalents.common.network.packet.data.DogObeyData;
import doggytalents.common.network.packet.data.DogTalentData;
import doggytalents.common.network.packet.data.DogTextureData;
import doggytalents.common.network.packet.data.FriendlyFireData;
import doggytalents.common.network.packet.data.SendSkinData;
import doggytalents.common.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class DogInfoScreen
extends Screen {
    public final DogEntity dog;
    public final PlayerEntity player;
    private int currentPage = 0;
    private int maxPages = 1;
    private List<Widget> talentWidgets = new ArrayList<Widget>(16);
    private Button leftBtn;
    private Button rightBtn;
    private List<Talent> talentList;
    private List<ResourceLocation> customSkinList;
    public int textureIndex;

    public DogInfoScreen(DogEntity dog, PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("doggytalents.screen.dog.title"));
        this.dog = dog;
        this.player = player;
        this.talentList = DoggyTalentsAPI.TALENTS.getValues().stream().sorted(Comparator.comparing(t -> I18n.func_135052_a((String)t.getTranslationKey(), (Object[])new Object[0]))).collect(Collectors.toList());
        this.customSkinList = DogTextureManager.INSTANCE.getAll();
        this.textureIndex = this.customSkinList.indexOf(DogTextureManager.INSTANCE.getTextureLoc(dog.getSkinHash()));
        this.textureIndex = this.textureIndex >= 0 ? this.textureIndex : 0;
    }

    public static void open(DogEntity dog) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new DogInfoScreen(dog, (PlayerEntity)mc.field_71439_g));
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int topX = this.field_230708_k_ / 2;
        int topY = this.field_230709_l_ / 2;
        TextFieldWidget nameTextField = new TextFieldWidget(this.field_230712_o_, topX - 100, topY + 50, 200, 20, (ITextComponent)new TranslationTextComponent("dogInfo.enterName"));
        nameTextField.func_212954_a(text -> PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogNameData(this.dog.func_145782_y(), (String)text)));
        nameTextField.func_146195_b(false);
        nameTextField.func_146203_f(32);
        if (this.dog.func_145818_k_()) {
            nameTextField.func_146180_a(this.dog.func_200201_e().func_150261_e());
        }
        this.func_230480_a_((Widget)nameTextField);
        if (this.dog.func_152114_e((LivingEntity)this.player)) {
            Button obeyBtn = new Button(this.field_230708_k_ - 64, topY + 77, 42, 20, (ITextComponent)new StringTextComponent(String.valueOf(this.dog.willObeyOthers())), btn -> {
                btn.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(!this.dog.willObeyOthers())));
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogObeyData(this.dog.func_145782_y(), !this.dog.willObeyOthers()));
            });
            this.func_230480_a_((Widget)obeyBtn);
        }
        Button attackPlayerBtn = new Button(this.field_230708_k_ - 64, topY - 5, 42, 20, (ITextComponent)new StringTextComponent(String.valueOf(this.dog.canPlayersAttack())), button -> {
            button.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(!this.dog.canPlayersAttack())));
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new FriendlyFireData(this.dog.func_145782_y(), !this.dog.canPlayersAttack()));
        });
        this.func_230480_a_((Widget)attackPlayerBtn);
        Button addBtn = new Button(this.field_230708_k_ - 42, topY + 30, 20, 20, (ITextComponent)new StringTextComponent("+"), btn -> {
            ++this.textureIndex;
            this.textureIndex %= this.customSkinList.size();
            ResourceLocation rl = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(rl);
        });
        Button lessBtn = new Button(this.field_230708_k_ - 64, topY + 30, 20, 20, (ITextComponent)new StringTextComponent("-"), btn -> {
            this.textureIndex += this.customSkinList.size() - 1;
            this.textureIndex %= this.customSkinList.size();
            ResourceLocation rl = this.customSkinList.get(this.textureIndex);
            this.setDogTexture(rl);
        });
        this.func_230480_a_((Widget)addBtn);
        this.func_230480_a_((Widget)lessBtn);
        Button modeBtn = new Button(topX + 40, topY + 25, 60, 20, (ITextComponent)new TranslationTextComponent(this.dog.getMode().getUnlocalisedName()), button -> {
            EnumMode mode = this.dog.getMode().nextMode();
            if (mode == EnumMode.WANDERING && !this.dog.getBowlPos().isPresent()) {
                button.func_238482_a_((ITextComponent)new TranslationTextComponent(mode.getUnlocalisedName()).func_240699_a_(TextFormatting.RED));
            } else {
                button.func_238482_a_((ITextComponent)new TranslationTextComponent(mode.getUnlocalisedName()));
            }
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogModeData(this.dog.func_145782_y(), mode));
        }){

            public void func_230443_a_(MatrixStack stack, int mouseX, int mouseY) {
                ArrayList<Object> list = new ArrayList<Object>();
                String str = I18n.func_135052_a((String)DogInfoScreen.this.dog.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, DogInfoScreen.this.field_230712_o_));
                if (DogInfoScreen.this.dog.getMode() == EnumMode.WANDERING) {
                    if (DogInfoScreen.this.dog.getBowlPos().isPresent()) {
                        double distance = DogInfoScreen.this.dog.func_233580_cy_().func_177951_i((Vector3i)DogInfoScreen.this.dog.getBowlPos().get());
                        if (distance > 256.0) {
                            list.add(new TranslationTextComponent("dog.mode.docile.distance", new Object[]{(int)Math.sqrt(distance)}).func_240699_a_(TextFormatting.RED));
                        } else {
                            list.add(new TranslationTextComponent("dog.mode.docile.bowl", new Object[]{(int)Math.sqrt(distance)}).func_240699_a_(TextFormatting.GREEN));
                        }
                    } else {
                        list.add(new TranslationTextComponent("dog.mode.docile.nobowl").func_240699_a_(TextFormatting.RED));
                    }
                }
                DogInfoScreen.this.func_243308_b(stack, list, mouseX, mouseY);
            }
        };
        this.func_230480_a_((Widget)modeBtn);
        int size = DoggyTalentsAPI.TALENTS.getKeys().size();
        int perPage = Math.max(MathHelper.func_76128_c((double)((double)(this.field_230709_l_ - 10) / 21.0)) - 2, 1);
        this.currentPage = 0;
        this.recalculatePage(perPage);
        if (perPage < size) {
            this.leftBtn = new Button(25, perPage * 21 + 10, 20, 20, (ITextComponent)new StringTextComponent("<"), btn -> {
                this.currentPage = Math.max(0, this.currentPage - 1);
                btn.field_230693_o_ = this.currentPage > 0;
                this.rightBtn.field_230693_o_ = true;
                this.recalculatePage(perPage);
            }){

                public void func_230443_a_(MatrixStack stack, int mouseX, int mouseY) {
                    DogInfoScreen.this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("doggui.prevpage").func_240699_a_(TextFormatting.ITALIC), mouseX, mouseY);
                }
            };
            this.leftBtn.field_230693_o_ = false;
            this.rightBtn = new Button(48, perPage * 21 + 10, 20, 20, (ITextComponent)new StringTextComponent(">"), btn -> {
                this.currentPage = Math.min(this.maxPages - 1, this.currentPage + 1);
                btn.field_230693_o_ = this.currentPage < this.maxPages - 1;
                this.leftBtn.field_230693_o_ = true;
                this.recalculatePage(perPage);
            }){

                public void func_230443_a_(MatrixStack stack, int mouseX, int mouseY) {
                    DogInfoScreen.this.func_238652_a_(stack, (ITextComponent)new TranslationTextComponent("doggui.nextpage").func_240699_a_(TextFormatting.ITALIC), mouseX, mouseY);
                }
            };
            this.func_230480_a_((Widget)this.leftBtn);
            this.func_230480_a_((Widget)this.rightBtn);
        }
    }

    private void setDogTexture(ResourceLocation rl) {
        if (ConfigValues.SEND_SKIN) {
            try {
                byte[] data = DogTextureManager.INSTANCE.getResourceBytes(rl);
                PacketHandler.send(PacketDistributor.SERVER.noArg(), new SendSkinData(this.dog.func_145782_y(), data));
            }
            catch (IOException e) {
                DoggyTalents2.LOGGER.error("Was unable to get resource data for {}, {}", (Object)rl, (Object)e);
            }
        } else {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTextureData(this.dog.func_145782_y(), DogTextureManager.INSTANCE.getTextureHash(rl)));
        }
    }

    private void recalculatePage(int perPage) {
        int index;
        this.talentWidgets.forEach(this::removeWidget);
        this.talentWidgets.clear();
        this.maxPages = MathHelper.func_76143_f((double)((double)this.talentList.size() / (double)perPage));
        for (int i = 0; i < perPage && (index = this.currentPage * perPage + i) < this.talentList.size(); ++i) {
            Talent talent = this.talentList.get(index);
            TalentButton button = new TalentButton(25, 10 + i * 21, 20, 20, (ITextComponent)new StringTextComponent("+"), talent, btn -> {
                int level = this.dog.getLevel(talent);
                if (level < talent.getMaxLevel() && this.dog.canSpendPoints(talent.getLevelCost(level + 1))) {
                    PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogTalentData(this.dog.func_145782_y(), talent));
                }
            }){

                public void func_230443_a_(MatrixStack stack, int mouseX, int mouseY) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(new TranslationTextComponent(this.talent.getTranslationKey()).func_240699_a_(TextFormatting.GREEN));
                    if (this.field_230693_o_) {
                        list.add(new StringTextComponent("Level: " + DogInfoScreen.this.dog.getLevel(this.talent)));
                        list.add(new StringTextComponent("--------------------------------").func_240699_a_(TextFormatting.GRAY));
                        list.addAll(ScreenUtil.splitInto(I18n.func_135052_a((String)this.talent.getInfoTranslationKey(), (Object[])new Object[0]), 200, DogInfoScreen.this.field_230712_o_));
                    } else {
                        list.add(new StringTextComponent("Talent disabled").func_240699_a_(TextFormatting.RED));
                    }
                    DogInfoScreen.this.func_243308_b(stack, list, mouseX, mouseY);
                }
            };
            button.field_230693_o_ = !ConfigValues.DISABLED_TALENTS.contains((Object)talent);
            this.talentWidgets.add((Widget)button);
            this.func_230480_a_((Widget)button);
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        int topX = this.field_230708_k_ / 2;
        int topY = this.field_230709_l_ / 2;
        this.func_230446_a_(stack);
        String health = Util.format1DP(this.dog.func_110143_aJ());
        String healthMax = Util.format1DP(this.dog.func_110138_aP());
        String speedValue = Util.format2DP(this.dog.func_110148_a(Attributes.field_233821_d_).func_111126_e());
        String armorValue = Util.format2DP(this.dog.func_110148_a(Attributes.field_233826_i_).func_111126_e());
        String ageValue = Util.format2DP(this.dog.func_70874_b());
        String ageRel = I18n.func_135052_a((String)(this.dog.func_70631_g_() ? "doggui.age.baby" : "doggui.age.adult"), (Object[])new Object[0]);
        String ageString = ageValue + " " + ageRel;
        String tamedString = "";
        if (this.dog.func_70909_n()) {
            if (this.dog.func_152114_e((LivingEntity)this.player)) {
                tamedString = I18n.func_135052_a((String)"doggui.owner.you", (Object[])new Object[0]);
            } else if (this.dog.getOwnersName().isPresent()) {
                tamedString = this.dog.getOwnersName().get().getString();
            }
        }
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.speed", (Object[])new Object[0]) + " " + speedValue, (float)(this.field_230708_k_ - 160), (float)(topY - 100), 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.owner", (Object[])new Object[0]) + " " + tamedString, (float)(this.field_230708_k_ - 160), (float)(topY - 90), 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.age", (Object[])new Object[0]) + " " + ageString, (float)(this.field_230708_k_ - 160), (float)(topY - 80), 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.armor", (Object[])new Object[0]) + " " + armorValue, (float)(this.field_230708_k_ - 160), (float)(topY - 70), 0xFFFFFF);
        if (ConfigValues.DOG_GENDER) {
            this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.gender", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)this.dog.getGender().getUnlocalisedName(), (Object[])new Object[0]), (float)(this.field_230708_k_ - 160), (float)(topY - 60), 0xFFFFFF);
        }
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.newname", (Object[])new Object[0]), (float)(topX - 100), (float)(topY + 38), 0x404040);
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.level", (Object[])new Object[0]) + " " + this.dog.getLevel().getLevel(DogLevel.Type.NORMAL), (float)(topX - 65), (float)(topY + 75), 16716025);
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.leveldire", (Object[])new Object[0]) + " " + this.dog.getLevel().getLevel(DogLevel.Type.DIRE), (float)topX, (float)(topY + 75), 16716025);
        if (this.dog.getAccessory((Accessory)DoggyAccessories.GOLDEN_COLLAR.get()).isPresent()) {
            this.field_230712_o_.func_238421_b_(stack, TextFormatting.GOLD + "Unlimited Points", (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        } else {
            this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.pointsleft", (Object[])new Object[0]) + " " + this.dog.getSpendablePoints(), (float)(topX - 38), (float)(topY + 89), 0xFFFFFF);
        }
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.textureindex", (Object[])new Object[0]), (float)(this.field_230708_k_ - 80), (float)(topY + 20), 0xFFFFFF);
        this.field_230712_o_.func_238421_b_(stack, this.dog.getSkinHash().substring(0, Math.min(this.dog.getSkinHash().length(), 10)), (float)(this.field_230708_k_ - 73), (float)(topY + 54), 0xFFFFFF);
        if (this.dog.func_152114_e((LivingEntity)this.player)) {
            this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.obeyothers", (Object[])new Object[0]), (float)(this.field_230708_k_ - 76), (float)(topY + 67), 0xFFFFFF);
        }
        this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)"doggui.friendlyfire", (Object[])new Object[0]), (float)(this.field_230708_k_ - 76), (float)(topY - 15), 0xFFFFFF);
        this.field_230710_m_.forEach(widget -> {
            if (widget instanceof TalentButton) {
                TalentButton talBut = (TalentButton)((Object)widget);
                this.field_230712_o_.func_238421_b_(stack, I18n.func_135052_a((String)talBut.talent.getTranslationKey(), (Object[])new Object[0]), (float)(talBut.field_230690_l_ + 25), (float)(talBut.field_230691_m_ + 7), 0xFFFFFF);
            }
        });
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        for (Widget widget2 : this.field_230710_m_) {
            if (!widget2.func_230449_g_()) continue;
            widget2.func_230443_a_(stack, mouseX, mouseY);
            break;
        }
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected <T extends Widget> T removeWidget(T widgetIn) {
        this.field_230710_m_.remove(widgetIn);
        this.field_230705_e_.remove(widgetIn);
        return widgetIn;
    }

    private static class TalentButton
    extends Button {
        protected Talent talent;

        private TalentButton(int x, int y, int widthIn, int heightIn, ITextComponent buttonText, Talent talent, Consumer<TalentButton> onPress) {
            super(x, y, widthIn, heightIn, buttonText, button -> onPress.accept((TalentButton)button));
            this.talent = talent;
        }
    }
}

