/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.world;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.DogEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class BedFinderRenderer {
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        for (Entity passenger : player.func_184188_bt()) {
            DogEntity dog;
            Optional<BlockPos> bedPosOpt;
            if (!(passenger instanceof DogEntity) || !(bedPosOpt = (dog = (DogEntity)passenger).getBedPos()).isPresent()) continue;
            BlockPos bedPos = bedPosOpt.get();
            int level = dog.getLevel((Supplier)DoggyTalents.BED_FINDER);
            double distance = (double)level * 200.0 - Math.sqrt(bedPos.func_177951_i((Vector3i)dog.func_233580_cy_()));
            if (level != 5 && !(distance >= 0.0)) continue;
            MatrixStack stack = event.getMatrixStack();
            AxisAlignedBB boundingBox = new AxisAlignedBB(bedPos).func_186662_g(0.5);
            BedFinderRenderer.drawSelectionBox(stack, boundingBox);
        }
    }

    public static void drawSelectionBox(MatrixStack stack, AxisAlignedBB boundingBox) {
        RenderSystem.disableAlphaTest();
        RenderSystem.disableLighting();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.disableTexture();
        Vector3d vec3d = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double d0 = vec3d.func_82615_a();
        double d1 = vec3d.func_82617_b();
        double d2 = vec3d.func_82616_c();
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        WorldRenderer.func_228430_a_((MatrixStack)stack, (IVertexBuilder)buf, (AxisAlignedBB)boundingBox.func_72317_d(-d0, -d1, -d2), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
        RenderSystem.enableLighting();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }
}

