/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.block.model.DogBedItemOverride;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class DogBedModel
implements IBakedModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("missingno");
    private ModelLoader modelLoader;
    private BlockModel model;
    private IBakedModel bakedModel;
    private final Map<Triple<IRegistryDelegate<ICasingMaterial>, IRegistryDelegate<IBeddingMaterial>, Direction>, IBakedModel> cache = Maps.newHashMap();

    public DogBedModel(ModelLoader modelLoader, BlockModel model, IBakedModel bakedModel) {
        this.modelLoader = modelLoader;
        this.model = model;
        this.bakedModel = bakedModel;
    }

    public IBakedModel getModelVariant(@Nonnull IModelData data) {
        return this.getModelVariant((ICasingMaterial)((Object)data.getData(DogBedTileEntity.CASING)), (IBeddingMaterial)((Object)data.getData(DogBedTileEntity.BEDDING)), (Direction)data.getData(DogBedTileEntity.FACING));
    }

    public IBakedModel getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, Direction facing) {
        ImmutableTriple key = ImmutableTriple.of((Object)(casing != null ? casing.delegate : null), (Object)(bedding != null ? bedding.delegate : null), (Object)(facing != null ? facing : Direction.NORTH));
        return this.cache.computeIfAbsent((Triple<IRegistryDelegate<ICasingMaterial>, IRegistryDelegate<IBeddingMaterial>, Direction>)key, k -> this.bakeModelVariant((IRegistryDelegate<ICasingMaterial>)((IRegistryDelegate)k.getLeft()), (IRegistryDelegate<IBeddingMaterial>)((IRegistryDelegate)k.getMiddle()), (Direction)k.getRight()));
    }

    public List<BakedQuad> func_200117_a(BlockState state, Direction side, Random rand) {
        return this.getModelVariant(null, null, Direction.NORTH).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        return this.getModelVariant(data).getQuads(state, side, rand, data);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.getModelVariant(data).getParticleTexture(data);
    }

    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ICasingMaterial casing = null;
        IBeddingMaterial bedding = null;
        Direction facing = Direction.NORTH;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof DogBedTileEntity) {
            casing = ((DogBedTileEntity)tile).getCasing();
            bedding = ((DogBedTileEntity)tile).getBedding();
        }
        if (state.func_235901_b_((Property)DogBedBlock.FACING)) {
            facing = (Direction)state.func_177229_b((Property)DogBedBlock.FACING);
        }
        tileData.setData(DogBedTileEntity.CASING, (Object)casing);
        tileData.setData(DogBedTileEntity.BEDDING, (Object)bedding);
        tileData.setData(DogBedTileEntity.FACING, (Object)facing);
        return tileData;
    }

    public IBakedModel bakeModelVariant(@Nullable IRegistryDelegate<ICasingMaterial> casingResource, @Nullable IRegistryDelegate<IBeddingMaterial> beddingResource, @Nonnull Direction facing) {
        List parts = this.model.func_178298_a();
        ArrayList<BlockPart> elements = new ArrayList<BlockPart>(parts.size());
        for (BlockPart part : parts) {
            elements.add(new BlockPart(part.field_178241_a, part.field_178239_b, (Map)Maps.newHashMap((Map)part.field_178240_c), part.field_178237_d, part.field_178238_e));
        }
        BlockModel newModel = new BlockModel(this.model.getParentLocation(), elements, (Map)Maps.newHashMap((Map)this.model.field_178318_c), this.model.func_178309_b(), this.model.func_230176_c_(), this.model.func_181682_g(), new ArrayList(this.model.func_187966_f()));
        newModel.field_178317_b = this.model.field_178317_b;
        newModel.field_178315_d = this.model.field_178315_d;
        Either<RenderMaterial, String> casingTexture = this.findCasingTexture(casingResource);
        newModel.field_178318_c.put("bedding", this.findBeddingTexture(beddingResource));
        newModel.field_178318_c.put("casing", casingTexture);
        newModel.field_178318_c.put("particle", casingTexture);
        return newModel.func_228813_a_((ModelBakery)this.modelLoader, newModel, ModelLoader.defaultTextureGetter(), (IModelTransform)this.getModelRotation(facing), this.createResourceVariant(casingResource, beddingResource, facing), true);
    }

    private ResourceLocation createResourceVariant(@Nonnull IRegistryDelegate<ICasingMaterial> casingResource, @Nonnull IRegistryDelegate<IBeddingMaterial> beddingResource, @Nonnull Direction facing) {
        String beddingKey = beddingResource != null ? beddingResource.name().toString().replace(':', '.') : "doggytalents.dogbed.bedding.missing";
        String casingKey = beddingResource != null ? casingResource.name().toString().replace(':', '.') : "doggytalents.dogbed.casing.missing";
        return new ModelResourceLocation("doggytalents", "block/dog_bed#bedding=" + beddingKey + ",casing=" + casingKey + ",facing=" + facing.func_176742_j());
    }

    private Either<RenderMaterial, String> findCasingTexture(@Nullable IRegistryDelegate<ICasingMaterial> resource) {
        return this.findTexture(resource != null ? ((ICasingMaterial)((Object)resource.get())).getTexture() : null);
    }

    private Either<RenderMaterial, String> findBeddingTexture(@Nullable IRegistryDelegate<IBeddingMaterial> resource) {
        return this.findTexture(resource != null ? ((IBeddingMaterial)((Object)resource.get())).getTexture() : null);
    }

    private Either<RenderMaterial, String> findTexture(@Nullable ResourceLocation resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new RenderMaterial(PlayerContainer.field_226615_c_, resource));
    }

    private ModelRotation getModelRotation(@Nonnull Direction dir) {
        switch (dir) {
            default: {
                return ModelRotation.X0_Y0;
            }
            case EAST: {
                return ModelRotation.X0_Y90;
            }
            case SOUTH: {
                return ModelRotation.X0_Y180;
            }
            case WEST: 
        }
        return ModelRotation.X0_Y270;
    }

    public boolean func_177555_b() {
        return this.bakedModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.bakedModel.func_177556_c();
    }

    public boolean func_230044_c_() {
        return this.bakedModel.func_230044_c_();
    }

    public boolean func_188618_c() {
        return this.bakedModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bakedModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.bakedModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return ITEM_OVERIDE;
    }
}

