/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.registry;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Talent;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IRegistryDelegate;

public class TalentInstance
implements IDogAlteration {
    protected final IRegistryDelegate<Talent> talentDelegate;
    protected int level;

    public TalentInstance(Talent talentIn, int levelIn) {
        this((IRegistryDelegate<Talent>)talentIn.delegate, levelIn);
    }

    public TalentInstance(Talent talentIn) {
        this((IRegistryDelegate<Talent>)talentIn.delegate, 1);
    }

    public TalentInstance(IRegistryDelegate<Talent> talentDelegateIn, int levelIn) {
        this.talentDelegate = talentDelegateIn;
        this.level = levelIn;
    }

    public Talent getTalent() {
        return (Talent)((Object)this.talentDelegate.get());
    }

    public final int level() {
        return this.level;
    }

    public final void setLevel(int levelIn) {
        this.level = levelIn;
    }

    public boolean of(Supplier<Talent> talentIn) {
        return this.of(talentIn.get());
    }

    public boolean of(Talent talentIn) {
        return this.of((IRegistryDelegate<Talent>)talentIn.delegate);
    }

    public boolean of(IRegistryDelegate<Talent> talentDelegateIn) {
        return talentDelegateIn.equals(this.talentDelegate);
    }

    public TalentInstance copy() {
        return ((Talent)((Object)this.talentDelegate.get())).getDefault(this.level);
    }

    public void writeToNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        compound.func_74768_a("level", this.level());
    }

    public void readFromNBT(AbstractDogEntity dogIn, CompoundNBT compound) {
        this.setLevel(compound.func_74762_e("level"));
    }

    public void writeToBuf(PacketBuffer buf) {
        buf.writeInt(this.level());
    }

    public void readFromBuf(PacketBuffer buf) {
        this.setLevel(buf.readInt());
    }

    public final void writeInstance(AbstractDogEntity dogIn, CompoundNBT compound) {
        ResourceLocation rl = this.talentDelegate.name();
        if (rl != null) {
            compound.func_74778_a("type", rl.toString());
        }
        this.writeToNBT(dogIn, compound);
    }

    public static Optional<TalentInstance> readInstance(AbstractDogEntity dogIn, CompoundNBT compound) {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)compound.func_74779_i("type"));
        if (DoggyTalentsAPI.TALENTS.containsKey(rl)) {
            TalentInstance inst = ((Talent)DoggyTalentsAPI.TALENTS.getValue(rl)).getDefault();
            inst.readFromNBT(dogIn, compound);
            return Optional.of(inst);
        }
        DoggyTalentsAPI.LOGGER.warn("Failed to load talent {}", (Object)rl);
        return Optional.empty();
    }

    public <T extends TalentInstance> T cast(Class<T> type) {
        if (this.getClass().isAssignableFrom(type)) {
            return (T)this;
        }
        throw new RuntimeException("Could not cast " + this.getClass().getName() + " to " + type.getName());
    }

    public String toString() {
        return String.format("%s [talent: %s, level: %d]", this.getClass().getSimpleName(), this.talentDelegate.name(), this.level);
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
    }

    public void set(AbstractDogEntity dog, int levelBefore) {
    }

    public boolean hasRenderer() {
        return this.getTalent().hasRenderer();
    }
}

