/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.common.entity.DogEntity;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.FoodBowlContainer;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.TreatBagContainer;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DoggyContainerTypes {
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"doggytalents");
    public static final RegistryObject<ContainerType<FoodBowlContainer>> FOOD_BOWL = DoggyContainerTypes.register("food_bowl", (windowId, inv, data) -> {
        BlockPos pos = data.func_179259_c();
        return new FoodBowlContainer(windowId, inv.field_70458_d.field_70170_p, pos, inv, inv.field_70458_d);
    });
    public static final RegistryObject<ContainerType<PackPuppyContainer>> PACK_PUPPY = DoggyContainerTypes.register("pack_puppy", (windowId, inv, data) -> {
        Entity entity = inv.field_70458_d.field_70170_p.func_73045_a(data.readInt());
        return entity instanceof DogEntity ? new PackPuppyContainer(windowId, inv, (DogEntity)entity) : null;
    });
    public static final RegistryObject<ContainerType<TreatBagContainer>> TREAT_BAG = DoggyContainerTypes.register("treat_bag", (windowId, inv, data) -> {
        byte slotId = data.readByte();
        return new TreatBagContainer(windowId, inv, slotId, data.func_150791_c());
    });
    public static final RegistryObject<ContainerType<DogInventoriesContainer>> DOG_INVENTORIES = DoggyContainerTypes.register("dog_inventories", (windowId, inv, data) -> {
        int noDogs = data.readInt();
        ArrayList<DogEntity> dogs = new ArrayList<DogEntity>(noDogs);
        IntArray array = new IntArray(noDogs);
        for (int i = 0; i < noDogs; ++i) {
            Entity entity = inv.field_70458_d.field_70170_p.func_73045_a(data.readInt());
            if (!(entity instanceof DogEntity)) continue;
            dogs.add((DogEntity)entity);
            array.func_221477_a(i, entity.func_145782_y());
        }
        return !dogs.isEmpty() ? new DogInventoriesContainer(windowId, inv, array) : null;
    });

    private static <X extends Container, T extends ContainerType<X>> RegistryObject<ContainerType<X>> register(String name, IContainerFactory<X> factory) {
        return DoggyContainerTypes.register(name, () -> IForgeContainerType.create((IContainerFactory)factory));
    }

    private static <T extends ContainerType<?>> RegistryObject<T> register(String name, Supplier<T> sup) {
        return CONTAINERS.register(name, sup);
    }
}

