/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.init;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.config.ModJetpacks;
import com.blakebr0.ironjetpacks.item.ComponentItem;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModItems {
    public static final Map<RegistryObject<Item>, Supplier<Item>> ENTRIES = new LinkedHashMap<RegistryObject<Item>, Supplier<Item>>();
    public static final RegistryObject<Item> STRAP = ModItems.register("strap");
    public static final RegistryObject<Item> BASIC_COIL = ModItems.register("basic_coil");
    public static final RegistryObject<Item> ADVANCED_COIL = ModItems.register("advanced_coil");
    public static final RegistryObject<Item> ELITE_COIL = ModItems.register("elite_coil");
    public static final RegistryObject<Item> ULTIMATE_COIL = ModItems.register("ultimate_coil");

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        ComponentItem item2;
        IForgeRegistry registry = event.getRegistry();
        ENTRIES.forEach((reg, item) -> {
            registry.register((IForgeRegistryEntry)item.get());
            reg.updateReference(registry);
        });
        ModJetpacks.loadJsons();
        List<Jetpack> jetpacks = JetpackRegistry.getInstance().getAllJetpacks();
        for (Jetpack jetpack : jetpacks) {
            item2 = new ComponentItem(jetpack, "cell", p -> p.func_200916_a(IronJetpacks.ITEM_GROUP));
            jetpack.setCellItem(item2);
            registry.register(item2.setRegistryName(jetpack.name + "_cell"));
        }
        for (Jetpack jetpack : jetpacks) {
            item2 = new ComponentItem(jetpack, "thruster", p -> p.func_200916_a(IronJetpacks.ITEM_GROUP));
            jetpack.setThrusterItem(item2);
            registry.register(item2.setRegistryName(jetpack.name + "_thruster"));
        }
        for (Jetpack jetpack : jetpacks) {
            item2 = new ComponentItem(jetpack, "capacitor", p -> p.func_200916_a(IronJetpacks.ITEM_GROUP));
            jetpack.setCapacitorItem(item2);
            registry.register(item2.setRegistryName(jetpack.name + "_capacitor"));
        }
        for (Jetpack jetpack : jetpacks) {
            registry.register(jetpack.item.setRegistryName(jetpack.name + "_jetpack"));
        }
    }

    private static RegistryObject<Item> register(String name) {
        return ModItems.register(name, () -> new BaseItem(p -> p.func_200916_a(IronJetpacks.ITEM_GROUP)));
    }

    private static RegistryObject<Item> register(String name, Supplier<? extends Item> item) {
        ResourceLocation loc = new ResourceLocation("ironjetpacks", name);
        RegistryObject reg = RegistryObject.of((ResourceLocation)loc, (IForgeRegistry)ForgeRegistries.ITEMS);
        ENTRIES.put((RegistryObject<Item>)reg, () -> (Item)((Item)item.get()).setRegistryName(loc));
        return reg;
    }
}

