/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.Tags;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;

public class SlimeTreeFeature
extends Feature<SlimeTreeConfig> {
    public SlimeTreeFeature(Codec<SlimeTreeConfig> codec) {
        super(codec);
    }

    public final boolean generate(ISeedReader seedReader, ChunkGenerator chunkGenerator, Random random, BlockPos blockPos, SlimeTreeConfig config) {
        HashSet trunkPos = Sets.newHashSet();
        HashSet foliagePos = Sets.newHashSet();
        HashSet leavesPos = Sets.newHashSet();
        MutableBoundingBox boundingBox = MutableBoundingBox.func_78887_a();
        boolean placed = this.place((IWorldGenerationReader)seedReader, random, blockPos, trunkPos, foliagePos, boundingBox, config);
        if (boundingBox.field_78897_a <= boundingBox.field_78893_d && placed && !trunkPos.isEmpty()) {
            VoxelShapePart voxelshapepart = this.func_236403_a_((IWorld)seedReader, boundingBox, trunkPos, leavesPos);
            Template.func_222857_a((IWorld)seedReader, (int)3, (VoxelShapePart)voxelshapepart, (int)boundingBox.field_78897_a, (int)boundingBox.field_78895_b, (int)boundingBox.field_78896_c);
            return true;
        }
        return false;
    }

    private boolean place(IWorldGenerationReader generationReader, Random rand, BlockPos positionIn, Set<BlockPos> trunkBlockPosSet, Set<BlockPos> foliagePositions, MutableBoundingBox boundingBoxIn, SlimeTreeConfig configIn) {
        if (!(generationReader instanceof IWorld)) {
            return false;
        }
        int height = rand.nextInt(configIn.randomHeight) + configIn.baseHeight;
        if (configIn.canDoubleHeight && rand.nextInt(10) == 0) {
            height *= 2;
        }
        if (positionIn.func_177956_o() >= 1 && positionIn.func_177956_o() + height + 1 <= 256 && SlimeTreeFeature.isSlimySoilAt((IWorldGenerationBaseReader)generationReader, positionIn.func_177977_b())) {
            this.setDirtAt(generationReader, positionIn.func_177977_b(), positionIn);
            this.placeTrunk(generationReader, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            this.placeCanopy(generationReader, rand, height, positionIn, trunkBlockPosSet, boundingBoxIn, configIn);
            return true;
        }
        return false;
    }

    protected void setDirtAt(IWorldGenerationReader reader, BlockPos pos, BlockPos origin) {
        if (!(reader instanceof IWorld)) {
            return;
        }
        BlockState state = ((IWorld)reader).func_180495_p(pos);
        if (state.func_235714_a_((ITag)Tags.Blocks.DIRT)) {
            reader.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 2);
        }
    }

    protected void placeTrunk(IWorldGenerationReader worldIn, Random randomIn, int treeHeight, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        while (treeHeight > 0) {
            this.setLog(worldIn, randomIn, blockPos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            blockPos = blockPos.func_177984_a();
            --treeHeight;
        }
    }

    protected void placeCanopy(IWorldGenerationReader worldIn, Random randomIn, int treeHeight, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        blockPos = blockPos.func_177981_b(treeHeight);
        for (int i = 0; i < 4; ++i) {
            this.placeDiamondLayer(worldIn, randomIn, i + 1, blockPos.func_177979_c(i), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        blockPos = blockPos.func_177979_c(3);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(-4, 0, 0), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(0, 0, 4), blockPosSet, mutableBoundingBoxIn);
        this.placeAir(worldIn, randomIn, blockPos.func_177982_a(0, 0, -4), blockPosSet, mutableBoundingBoxIn);
        if (treeFeatureConfigIn.hasVines) {
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(1, 0, -1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(-1, 0, 1), blockPosSet, mutableBoundingBoxIn);
            this.placeAir(worldIn, randomIn, blockPos.func_177982_a(-1, 0, -1), blockPosSet, mutableBoundingBoxIn);
        }
        blockPos = blockPos.func_177977_b();
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(0, 0, -3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(0, 0, 3), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        if (!treeFeatureConfigIn.hasVines) {
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-1, 0, 1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            this.setLeaf(worldIn, randomIn, blockPos.func_177982_a(-1, 0, -1), blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
        }
        if (treeFeatureConfigIn.hasVines) {
            blockPos = blockPos.func_177977_b();
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(3, 0, 0), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-3, 0, 0), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(0, 0, -3), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(0, 0, 3), blockPosSet, mutableBoundingBoxIn, (BlockState)this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn).func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            BlockState randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 1, 2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 1, -2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 1, 2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 0, 2), blockPosSet, mutableBoundingBoxIn, randomVine);
            randomVine = this.getRandomizedVine(randomIn, blockPos, treeFeatureConfigIn);
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 1, -2), blockPosSet, mutableBoundingBoxIn, (BlockState)randomVine.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)));
            this.placeVine(worldIn, randomIn, blockPos.func_177982_a(-2, 0, -2), blockPosSet, mutableBoundingBoxIn, randomVine);
        }
    }

    private void placeDiamondLayer(IWorldGenerationReader worldIn, Random randomIn, int range, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) + Math.abs(z) > range) continue;
                BlockPos blockpos = blockPos.func_177982_a(x, 0, z);
                this.setLeaf(worldIn, randomIn, blockpos, blockPosSet, mutableBoundingBoxIn, treeFeatureConfigIn);
            }
        }
    }

    protected boolean setLog(IWorldGenerationReader worldIn, Random randomIn, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, treeFeatureConfigIn.trunkProvider.func_225574_a_(randomIn, blockPos));
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    protected boolean placeAir(IWorldGenerationReader worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, Blocks.field_150350_a.func_176223_P());
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    protected boolean setLeaf(IWorldGenerationReader worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, SlimeTreeConfig treeFeatureConfigIn) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, treeFeatureConfigIn.leavesProvider.func_225574_a_(random, blockPos));
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    protected boolean placeVine(IWorldGenerationReader worldIn, Random random, BlockPos blockPos, Set<BlockPos> blockPosSet, MutableBoundingBox mutableBoundingBoxIn, BlockState vineState) {
        if (!SlimeTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)worldIn, blockPos)) {
            return false;
        }
        this.func_230367_a_((IWorldWriter)worldIn, blockPos, vineState);
        mutableBoundingBoxIn.func_78888_b(new MutableBoundingBox((Vector3i)blockPos, (Vector3i)blockPos));
        blockPosSet.add(blockPos.func_185334_h());
        return true;
    }

    private BlockState getRandomizedVine(Random random, BlockPos blockPos, SlimeTreeConfig config) {
        BooleanProperty[] sides;
        BlockState state = config.vinesProvider.func_225574_a_(random, blockPos);
        for (BooleanProperty side : sides = new BooleanProperty[]{VineBlock.field_176273_b, VineBlock.field_176278_M, VineBlock.field_176279_N, VineBlock.field_176280_O}) {
            state = (BlockState)state.func_206870_a((Property)side, (Comparable)Boolean.valueOf(false));
        }
        for (int i = random.nextInt(3) + 1; i > 0; --i) {
            state = (BlockState)state.func_206870_a((Property)sides[random.nextInt(sides.length)], (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean isEmptyOrLogAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return SlimeTreeFeature.isReplaceableAt(reader, blockPos) || reader.func_217375_a(blockPos, state -> state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isVineAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, state -> state.func_203425_a(Blocks.field_150395_bd));
    }

    private static boolean isWaterAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, state -> state.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeavesAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isSlimySoilAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, state -> TinkerTags.Blocks.SLIMY_SOIL.func_230235_a_((Object)state.func_177230_c()));
    }

    private static boolean isTallPlantAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return reader.func_217375_a(blockPos, state -> state.func_185904_a() == Material.field_151582_l);
    }

    public static boolean isReplaceableAt(IWorldGenerationBaseReader reader, BlockPos blockPos) {
        return SlimeTreeFeature.isAirOrLeavesAt(reader, blockPos) || SlimeTreeFeature.isTallPlantAt(reader, blockPos) || SlimeTreeFeature.isWaterAt(reader, blockPos);
    }

    public static void setBlockStateAt(IWorldWriter writer, BlockPos blockPos, BlockState state) {
        writer.func_180501_a(blockPos, state, 19);
    }

    private VoxelShapePart func_236403_a_(IWorld world, MutableBoundingBox boundingBox, Set<BlockPos> logs, Set<BlockPos> leaves) {
        ArrayList distanceList = Lists.newArrayList();
        BitSetVoxelShapePart shapePart = new BitSetVoxelShapePart(boundingBox.func_78883_b(), boundingBox.func_78882_c(), boundingBox.func_78880_d());
        for (int j = 0; j < 6; ++j) {
            distanceList.add(Sets.newHashSet());
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos leavePos : Lists.newArrayList(leaves)) {
            if (!boundingBox.func_175898_b((Vector3i)leavePos)) continue;
            shapePart.func_199625_a(leavePos.func_177958_n() - boundingBox.field_78897_a, leavePos.func_177956_o() - boundingBox.field_78895_b, leavePos.func_177952_p() - boundingBox.field_78896_c, true, true);
        }
        for (BlockPos logPos : Lists.newArrayList(logs)) {
            if (boundingBox.func_175898_b((Vector3i)logPos)) {
                shapePart.func_199625_a(logPos.func_177958_n() - boundingBox.field_78897_a, logPos.func_177956_o() - boundingBox.field_78895_b, logPos.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                mutable.func_239622_a_((Vector3i)logPos, direction);
                if (logs.contains(mutable) || !(blockstate = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)distanceList.get(0)).add(mutable.func_185334_h());
                SlimeTreeFeature.setBlockStateAt((IWorldWriter)world, (BlockPos)mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!boundingBox.func_175898_b((Vector3i)mutable)) continue;
                shapePart.func_199625_a(mutable.func_177958_n() - boundingBox.field_78897_a, mutable.func_177956_o() - boundingBox.field_78895_b, mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
            }
        }
        for (int distance = 1; distance < 6; ++distance) {
            Set current = (Set)distanceList.get(distance - 1);
            Set next = (Set)distanceList.get(distance);
            for (BlockPos pos : current) {
                if (boundingBox.func_175898_b((Vector3i)pos)) {
                    shapePart.func_199625_a(pos.func_177958_n() - boundingBox.field_78897_a, pos.func_177956_o() - boundingBox.field_78895_b, pos.func_177952_p() - boundingBox.field_78896_c, true, true);
                }
                for (Direction direction : Direction.values()) {
                    int stateDistance;
                    BlockState state;
                    mutable.func_239622_a_((Vector3i)pos, direction);
                    if (current.contains(mutable) || next.contains(mutable) || !(state = world.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (stateDistance = ((Integer)state.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= distance + 1) continue;
                    BlockState furtherState = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(distance + 1));
                    SlimeTreeFeature.setBlockStateAt((IWorldWriter)world, (BlockPos)mutable, furtherState);
                    if (boundingBox.func_175898_b((Vector3i)mutable)) {
                        shapePart.func_199625_a(mutable.func_177958_n() - boundingBox.field_78897_a, mutable.func_177956_o() - boundingBox.field_78895_b, mutable.func_177952_p() - boundingBox.field_78896_c, true, true);
                    }
                    next.add(mutable.func_185334_h());
                }
            }
        }
        return shapePart;
    }
}

