/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands.variants;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.variants.AbstractSlimeIslandVariant;

public class EnderSlimeIslandVariant
extends AbstractSlimeIslandVariant {
    public EnderSlimeIslandVariant(int index) {
        super(index, SlimeType.ENDER, SlimeType.ENDER);
    }

    @Override
    public ResourceLocation getStructureName(String variantName) {
        return TConstruct.getResource("slime_islands/ender/" + variantName);
    }

    @Override
    protected SlimeType getCongealedSlimeType(Random random) {
        return SlimeType.ENDER;
    }

    @Override
    @Nullable
    public BlockState getVines() {
        return ((SlimeVineBlock)TinkerWorld.enderSlimeVine.get()).func_176223_P();
    }

    @Override
    public BlockState getLakeFluid() {
        return Objects.requireNonNull(TinkerFluids.enderSlime.getBlock()).func_176223_P();
    }

    @Override
    @Nullable
    public ConfiguredFeature<?, ?> getTreeFeature(Random random) {
        return TinkerStructures.ENDER_SLIME_ISLAND_TREE;
    }
}

