/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import slimeknights.tconstruct.TConstruct;

public class TerracubeRenderer
extends MobRenderer<SlimeEntity, MagmaCubeModel<SlimeEntity>> {
    public static final Factory TERRACUBE_RENDERER = new Factory(TConstruct.getResource("textures/entity/terracube.png"));
    private final ResourceLocation texture;

    public TerracubeRenderer(EntityRendererManager manager, ResourceLocation texture) {
        super(manager, (EntityModel)new MagmaCubeModel(), 0.25f);
        this.texture = texture;
    }

    public ResourceLocation getEntityTexture(SlimeEntity entity) {
        return this.texture;
    }

    protected void preRenderCallback(SlimeEntity slime, MatrixStack matrices, float partialTickTime) {
        int size = slime.func_70809_q();
        float squishFactor = MathHelper.func_219799_g((float)partialTickTime, (float)slime.field_70812_c, (float)slime.field_70811_b) / ((float)size * 0.5f + 1.0f);
        float invertedSquish = 1.0f / (squishFactor + 1.0f);
        matrices.func_227862_a_(invertedSquish * (float)size, 1.0f / invertedSquish * (float)size, invertedSquish * (float)size);
    }

    public static class Factory
    implements IRenderFactory<SlimeEntity> {
        private final ResourceLocation texture;

        public EntityRenderer<? super SlimeEntity> createRenderFor(EntityRendererManager manager) {
            return new TerracubeRenderer(manager, this.texture);
        }

        public Factory(ResourceLocation texture) {
            this.texture = texture;
        }
    }
}

