/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;

public class SlimeGrassBlock
extends SnowyDirtBlock
implements IGrowable {
    private final SlimeType foliageType;

    public SlimeGrassBlock(AbstractBlock.Properties properties, SlimeType foliageType) {
        super(properties);
        this.foliageType = foliageType;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.foliageType != SlimeType.ICHOR) {
            super.func_149666_a(group, items);
        }
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return world.func_180495_p(pos.func_177984_a()).isAir(world, pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public static void growGrass(ServerWorld world, Random rand, BlockPos pos, ITag<Block> validBase, SlimeType foliageType, boolean includeSapling, boolean spread) {
        BlockPos up = pos.func_177984_a();
        block0: for (int i = 0; i < 128; ++i) {
            int plant;
            BlockState plantState;
            BlockPos target = up;
            for (int j = 0; j < i / 16; ++j) {
                target = target.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1);
                BlockPos below = target.func_177977_b();
                BlockState belowState = world.func_180495_p(below);
                if (world.func_180495_p(target).func_235785_r_((IBlockReader)world, target)) continue block0;
                if (spread && TinkerWorld.allDirt.contains((IForgeRegistryEntry)belowState.func_177230_c())) {
                    BlockState grassState = SlimeGrassBlock.getStateFromDirt(belowState, foliageType);
                    if (grassState == null) continue block0;
                    world.func_175656_a(below, grassState);
                    continue block0;
                }
                if (!belowState.func_235714_a_(validBase)) continue block0;
            }
            if (!world.func_175623_d(target) || !(plantState = (plant = rand.nextInt(32)) == 0 && includeSapling ? ((Block)TinkerWorld.slimeSapling.get((Enum)foliageType)).func_176223_P() : (plant < 6 ? ((SlimeTallGrassBlock)TinkerWorld.slimeFern.get((Enum)foliageType)).func_176223_P() : ((SlimeTallGrassBlock)TinkerWorld.slimeTallGrass.get((Enum)foliageType)).func_176223_P())).func_196955_c((IWorldReader)world, target)) continue;
            world.func_180501_a(target, plantState, 3);
        }
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        SlimeGrassBlock.growGrass(world, rand, pos, TinkerTags.Blocks.SLIMY_GRASS, this.foliageType, false, false);
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (!world.isAreaLoaded(pos, 3)) {
            return;
        }
        if (!SlimeGrassBlock.isValidPos(state, (IWorldReader)world, pos)) {
            world.func_175656_a(pos, SlimeGrassBlock.getDirtState(state));
        } else if (world.func_201696_r(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos newGrass = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                BlockState newState = SlimeGrassBlock.getStateFromDirt(world.func_180495_p(newGrass), this.foliageType);
                if (newState == null || !SlimeGrassBlock.canSpread(newState, (IWorldReader)world, newGrass)) continue;
                world.func_175656_a(newGrass, (BlockState)newState.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(world.func_180495_p(newGrass.func_177984_a()).func_203425_a(Blocks.field_150433_aE))));
            }
        }
    }

    private static boolean isValidPos(BlockState targetState, IWorldReader world, BlockPos pos) {
        BlockPos above = pos.func_177984_a();
        BlockState aboveState = world.func_180495_p(above);
        if (aboveState.func_203425_a(Blocks.field_150433_aE) && (Integer)aboveState.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        if (aboveState.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        return LightEngine.func_215613_a((IBlockReader)world, (BlockState)targetState, (BlockPos)pos, (BlockState)aboveState, (BlockPos)above, (Direction)Direction.UP, (int)aboveState.func_200016_a((IBlockReader)world, above)) < world.func_201572_C();
    }

    private static boolean canSpread(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos above = pos.func_177984_a();
        return SlimeGrassBlock.isValidPos(state, world, pos) && !world.func_204610_c(above).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static BlockState getDirtState(BlockState grassState) {
        Block block = grassState.func_177230_c();
        for (SlimeType type : SlimeType.values()) {
            if (!TinkerWorld.slimeGrass.get((Object)type).contains((IForgeRegistryEntry)block)) continue;
            return ((Block)TinkerWorld.allDirt.get((Enum)type)).func_176223_P();
        }
        return Blocks.field_150346_d.func_176223_P();
    }

    @Nullable
    public static BlockState getStateFromDirt(BlockState dirtState, SlimeType foliageType) {
        Block block = dirtState.func_177230_c();
        for (SlimeType type : SlimeType.values()) {
            if (TinkerWorld.allDirt.get((Enum)type) != block) continue;
            return ((Block)TinkerWorld.slimeGrass.get((Object)type).get((Enum)foliageType)).func_176223_P();
        }
        return null;
    }

    public SlimeType getFoliageType() {
        return this.foliageType;
    }
}

