/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ThornsModifier
extends IncrementalModifier {
    public ThornsModifier() {
        super(10463085);
    }

    @Override
    public void onAttacked(IModifierToolStack tool, int level, EquipmentContext context, EquipmentSlotType slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.func_76346_g();
        if (attacker != null && isDirectDamage) {
            float scaledLevel = this.getScaledLevel(tool, level);
            if (RANDOM.nextFloat() < scaledLevel * 0.15f) {
                float damage = scaledLevel > 10.0f ? scaledLevel - 10.0f : (float)(1 + RANDOM.nextInt(4));
                LivingEntity user = context.getEntity();
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)user), damage);
                ToolDamageUtil.damageAnimated(tool, 1, user, slotType);
            }
        }
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        PlayerEntity player = context.getPlayerAttacker();
        DamageSource source = player != null ? DamageSource.func_76365_a((PlayerEntity)player) : DamageSource.func_76358_a((LivingEntity)context.getAttacker());
        source.func_76348_h();
        float secondaryDamage = this.getScaledLevel(tool, level) * tool.getModifier(ToolStats.ATTACK_DAMAGE) * 0.75f * context.getCooldown();
        if (context.isCritical()) {
            secondaryDamage *= 1.5f;
        }
        ToolAttackUtil.attackEntitySecondary(source, secondaryDamage, context.getTarget(), context.getLivingTarget(), true);
        return 0;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, TooltipFlag flag) {
        if (tool.getModifierLevel((Modifier)TinkerModifiers.unarmed.get()) > 0) {
            this.addDamageTooltip(tool, this.getScaledLevel(tool, level) * 0.75f, tooltip);
        }
    }
}

