/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class TemperateModifier
extends Modifier {
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final ITextComponent MINING_SPEED = TConstruct.makeTranslation("modifier", "temperate.mining_speed");

    public TemperateModifier() {
        super(10245699);
    }

    private static float getBonus(PlayerEntity player, BlockPos pos, int level) {
        return Math.abs(player.field_70170_p.func_226691_t_(pos).func_225486_c(pos) - 0.75f) * (float)level / 10.0f;
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + TemperateModifier.getBonus(event.getPlayer(), event.getPos(), level)));
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        float bonus = player != null && key == TooltipKey.SHIFT ? TemperateModifier.getBonus(player, player.func_233580_cy_(), level) : (float)level * 0.125f;
        if (bonus >= 0.01f) {
            this.addPercentTooltip(MINING_SPEED, bonus, tooltip);
        }
    }
}

