/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.data.ISafeManagerReloadListener;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.ArmorModelWrapper;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class PlateArmorModel<T extends LivingEntity>
extends ArmorModelWrapper<T> {
    private static final PlateArmorModel<LivingEntity> INSTANCE = new PlateArmorModel();
    private static final Map<String, RenderType> ARMOR_RENDER_CACHE = new HashMap<String, RenderType>();
    private static final Map<String, RenderType> LEG_RENDER_CACHE = new HashMap<String, RenderType>();
    private static final Function<String, RenderType> ARMOR_GETTER = mat -> RenderType.func_239267_e_((ResourceLocation)PlateArmorModel.getArmorTexture(mat, 1));
    private static final Function<String, RenderType> LEG_GETTER = mat -> RenderType.func_239267_e_((ResourceLocation)PlateArmorModel.getArmorTexture(mat, 2));
    public static final ISafeManagerReloadListener RELOAD_LISTENER = manager -> {
        ARMOR_RENDER_CACHE.clear();
        LEG_RENDER_CACHE.clear();
    };
    private String material = "";
    private boolean isLegs = false;
    private boolean hasGlint = false;

    private static ResourceLocation getArmorTexture(String material, int variant) {
        ResourceLocation location = ResourceLocation.func_208304_a((String)material);
        if (location == null) {
            location = MaterialIds.cobalt;
        }
        return TConstruct.getResource(String.format("textures/models/armor/plate/layer_%d_%s_%s.png", variant, location.func_110624_b(), location.func_110623_a()));
    }

    public static <A extends BipedModel<?>> A getModel(ItemStack stack, EquipmentSlotType slot, A baseModel) {
        super.setup(stack, slot, baseModel);
        return (A)((Object)INSTANCE);
    }

    @Override
    public void func_225598_a_(MatrixStack matrices, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null) {
            this.copyToBase();
            this.base.func_225598_a_(matrices, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            if (!this.material.isEmpty() && buffer != null) {
                IVertexBuilder overlayBuffer = ItemRenderer.func_239386_a_((IRenderTypeBuffer)buffer, (RenderType)(this.isLegs ? LEG_RENDER_CACHE.computeIfAbsent(this.material, LEG_GETTER) : ARMOR_RENDER_CACHE.computeIfAbsent(this.material, ARMOR_GETTER)), (boolean)false, (boolean)this.hasGlint);
                this.base.func_225598_a_(matrices, overlayBuffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
    }

    private void setup(ItemStack stack, EquipmentSlotType slot, BipedModel<?> base) {
        this.base = base;
        this.material = ModifierUtil.getModifierLevel(stack, (Modifier)TinkerModifiers.golden.get()) > 0 ? MaterialIds.gold.toString() : ModifierUtil.getPersistentString(stack, TinkerModifiers.embellishment.getId());
        this.isLegs = slot == EquipmentSlotType.LEGS;
        this.hasGlint = stack.func_77962_s();
    }
}

