/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.module.alloying;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.tileentity.MantleTileEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.recipe.alloying.IMutableAlloyTank;

public class MixerAlloyTank
implements IMutableAlloyTank {
    private final MantleTileEntity parent;
    private final IFluidHandler outputTank;
    private int temperature = 0;
    private final Map<Direction, LazyOptional<IFluidHandler>> inputs = new EnumMap<Direction, LazyOptional<IFluidHandler>>(Direction.class);
    private final Map<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>> listeners = new EnumMap<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>>(Direction.class);
    @Nullable
    private IFluidHandler[] indexedList = null;
    private boolean needsRefresh = true;
    private int currentTanks = 0;

    @Override
    public int getTanks() {
        this.checkTanks();
        return this.currentTanks;
    }

    private IFluidHandler[] indexTanks() {
        if (this.indexedList == null) {
            this.indexedList = new IFluidHandler[this.currentTanks];
            if (this.currentTanks > 0) {
                int nextTank = 0;
                for (Direction direction : Direction.values()) {
                    LazyOptional<IFluidHandler> handler;
                    if (direction == Direction.DOWN || !(handler = this.inputs.getOrDefault(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty())).isPresent()) continue;
                    this.indexedList[nextTank] = (IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE);
                    ++nextTank;
                }
            }
        }
        return this.indexedList;
    }

    public IFluidHandler getFluidHandler(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return EmptyFluidHandler.INSTANCE;
        }
        return this.indexTanks()[tank];
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return this.indexTanks()[tank].getFluidInTank(0);
    }

    @Override
    public FluidStack drain(int tank, FluidStack fluidStack) {
        this.checkTanks();
        if (tank >= this.currentTanks || tank < 0) {
            return FluidStack.EMPTY;
        }
        return this.indexTanks()[tank].drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public boolean canFit(FluidStack fluid, int removed) {
        this.checkTanks();
        return this.outputTank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount();
    }

    @Override
    public int fill(FluidStack fluidStack) {
        return this.outputTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
    }

    private void checkTanks() {
        World world = this.parent.func_145831_w();
        if (world == null) {
            return;
        }
        if (this.needsRefresh) {
            for (Direction direction : Direction.values()) {
                BlockPos target;
                if (direction == Direction.DOWN || this.inputs.containsKey(direction) || !world.func_180495_p(target = this.parent.func_174877_v().func_177972_a(direction)).func_235714_a_(TinkerTags.Blocks.ALLOYER_TANKS)) continue;
                TileEntity te = world.func_175625_s(target);
                if (te != null) {
                    LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d());
                    if (capability.isPresent()) {
                        capability.addListener(this.listeners.computeIfAbsent(direction, dir -> new WeakConsumerWrapper((Object)this, (self, handler) -> {
                            if (handler == self.inputs.get(dir)) {
                                this.refresh((Direction)dir, false);
                            }
                        })));
                        this.inputs.put(direction, (LazyOptional<IFluidHandler>)capability);
                        ++this.currentTanks;
                        continue;
                    }
                    this.inputs.put(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty());
                    continue;
                }
                this.inputs.put(direction, (LazyOptional<IFluidHandler>)LazyOptional.empty());
            }
            this.needsRefresh = false;
            if (!world.field_72995_K) {
                for (PlayerEntity player : world.func_217369_A()) {
                    if (!(player.field_71070_bA instanceof BaseContainer) || ((BaseContainer)player.field_71070_bA).getTile() != this.parent) continue;
                    player.func_71053_j();
                }
            }
        }
    }

    public void refresh(Direction direction, boolean checkInput) {
        if (direction == Direction.DOWN) {
            return;
        }
        if (!checkInput || this.inputs.containsKey(direction) && this.inputs.get(direction).isPresent()) {
            --this.currentTanks;
        }
        this.inputs.remove(direction);
        this.needsRefresh = true;
        this.indexedList = null;
    }

    public MixerAlloyTank(MantleTileEntity parent, IFluidHandler outputTank) {
        this.parent = parent;
        this.outputTank = outputTank;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int temperature) {
        this.temperature = temperature;
    }
}

