/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.FaucetFluidLoader;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.fluid.FluidsModel;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.mantle.client.render.RenderingHelper;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.tileentity.FaucetTileEntity;

public class FaucetTileEntityRenderer
extends TileEntityRenderer<FaucetTileEntity> {
    public FaucetTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(FaucetTileEntity tileEntity, float partialTicks, MatrixStack matrices, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        FluidStack renderFluid = tileEntity.getRenderFluid();
        if (!tileEntity.isPouring() || renderFluid.isEmpty()) {
            return;
        }
        World world = tileEntity.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = tileEntity.func_195044_w();
        FluidsModel.BakedModel model = (FluidsModel.BakedModel)ModelHelper.getBakedModel((BlockState)state, FluidsModel.BakedModel.class);
        if (model != null) {
            Direction direction = (Direction)state.func_177229_b((Property)FaucetBlock.FACING);
            boolean isRotated = RenderingHelper.applyRotation((MatrixStack)matrices, (Direction)direction);
            FluidAttributes attributes = renderFluid.getFluid().getAttributes();
            int color = attributes.getColor(renderFluid);
            Function spriteGetter = Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_);
            TextureAtlasSprite still = (TextureAtlasSprite)spriteGetter.apply(attributes.getStillTexture(renderFluid));
            TextureAtlasSprite flowing = (TextureAtlasSprite)spriteGetter.apply(attributes.getFlowingTexture(renderFluid));
            boolean isGas = attributes.isGaseous(renderFluid);
            combinedLightIn = FluidRenderer.withBlockLight((int)combinedLightIn, (int)attributes.getLuminosity(renderFluid));
            IVertexBuilder buffer = bufferIn.getBuffer(FluidRenderer.RENDER_TYPE);
            for (FluidCuboid cube : model.getFluids()) {
                FluidRenderer.renderCuboid((MatrixStack)matrices, (IVertexBuilder)buffer, (FluidCuboid)cube, (float)0.0f, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)combinedLightIn, (boolean)isGas);
            }
            FaucetFluidLoader.renderFaucetFluids((IWorld)world, (BlockPos)tileEntity.func_174877_v(), (Direction)direction, (MatrixStack)matrices, (IVertexBuilder)buffer, (TextureAtlasSprite)still, (TextureAtlasSprite)flowing, (int)color, (int)combinedLightIn);
            if (isRotated) {
                matrices.func_227865_b_();
            }
        }
    }
}

