/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.inventory.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.client.FluidTooltipHandler;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.network.SmelteryFluidClickedPacket;
import slimeknights.tconstruct.smeltery.tileentity.tank.SmelteryTank;

public class GuiSmelteryTank {
    public static final String TOOLTIP_CAPACITY = TConstruct.makeTranslationKey("gui", "melting.capacity");
    public static final String TOOLTIP_AVAILABLE = TConstruct.makeTranslationKey("gui", "melting.available");
    public static final String TOOLTIP_USED = TConstruct.makeTranslationKey("gui", "melting.used");
    private final ContainerScreen<?> parent;
    private final SmelteryTank tank;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int[] liquidHeights;

    private int[] calcLiquidHeights(boolean refresh) {
        assert (this.tank != null);
        if (this.liquidHeights == null || refresh) {
            this.liquidHeights = GuiSmelteryTank.calcLiquidHeights(this.tank.getFluids(), Math.max(this.tank.getContained(), this.tank.getCapacity()), this.height, 3);
        }
        return this.liquidHeights;
    }

    private boolean withinTank(int checkX, int checkY) {
        return this.x <= checkX && checkX < this.x + this.width && this.y <= checkY && checkY < this.y + this.height;
    }

    public void renderFluids(MatrixStack matrices) {
        if (this.tank.getContained() > 0) {
            int[] heights = this.calcLiquidHeights(true);
            int bottom = this.y + this.width;
            for (int i = 0; i < heights.length; ++i) {
                int fluidH = heights[i];
                FluidStack liquid = this.tank.getFluids().get(i);
                GuiUtil.renderTiledFluid(matrices, this.parent, liquid, this.x, bottom - fluidH, this.width, fluidH, 100);
                bottom -= fluidH;
            }
        }
    }

    private int getFluidHovered(int[] heights, int y) {
        for (int i = 0; i < heights.length; ++i) {
            if (y < heights[i]) {
                return i;
            }
            y -= heights[i];
        }
        return -1;
    }

    private int getFluidFromMouse(int[] heights, int checkY) {
        return this.getFluidHovered(heights, this.y + this.height - checkY - 1);
    }

    public void renderHighlight(MatrixStack matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.parent.field_147003_i;
        int checkY = mouseY - this.parent.field_147009_r;
        if (this.withinTank(checkX, checkY)) {
            if (this.tank.getContained() == 0) {
                GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height);
            } else {
                int[] heights = this.calcLiquidHeights(false);
                int hovered = this.getFluidFromMouse(heights, checkY);
                int heightSum = 0;
                int loopMax = hovered == -1 ? heights.length : hovered + 1;
                for (int i = 0; i < loopMax; ++i) {
                    heightSum += heights[i];
                }
                if (hovered == -1) {
                    GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height - heightSum);
                } else {
                    GuiUtil.renderHighlight(matrices, this.x, this.y + this.height - heightSum, this.width, heights[hovered]);
                }
            }
        }
    }

    public void drawTooltip(MatrixStack matrices, int mouseX, int mouseY) {
        int checkX = mouseX - this.parent.field_147003_i;
        int checkY = mouseY - this.parent.field_147009_r;
        if (this.withinTank(checkX, checkY)) {
            List<ITextComponent> tooltip;
            int hovered;
            int n = hovered = this.tank.getContained() == 0 ? -1 : this.getFluidFromMouse(this.calcLiquidHeights(false), checkY);
            if (hovered == -1) {
                int used;
                BiConsumer<Integer, List> formatter = Screen.func_231173_s_() ? FluidTooltipHandler::appendBuckets : FluidTooltipHandler::appendIngots;
                tooltip = new ArrayList<ITextComponent>();
                tooltip.add((ITextComponent)new TranslationTextComponent(TOOLTIP_CAPACITY));
                formatter.accept(this.tank.getCapacity(), tooltip);
                int remaining = this.tank.getRemainingSpace();
                if (remaining > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(TOOLTIP_AVAILABLE));
                    formatter.accept(remaining, tooltip);
                }
                if ((used = this.tank.getContained()) > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(TOOLTIP_USED));
                    formatter.accept(used, tooltip);
                }
                FluidTooltipHandler.appendShift(tooltip);
            } else {
                tooltip = FluidTooltipHandler.getFluidTooltip(this.tank.getFluidInTank(hovered));
            }
            this.parent.func_243308_b(matrices, tooltip, mouseX, mouseY);
        }
    }

    public void handleClick(int mouseX, int mouseY) {
        int index;
        if (this.tank.getContained() > 0 && this.withinTank(mouseX, mouseY) && (index = this.getFluidFromMouse(this.calcLiquidHeights(false), mouseY)) != -1) {
            TinkerNetwork.getInstance().sendToServer(new SmelteryFluidClickedPacket(index));
        }
    }

    @Nullable
    public FluidStack getIngredient(int checkX, int checkY) {
        int index;
        if (this.tank.getContained() > 0 && this.withinTank(checkX, checkY) && (index = this.getFluidFromMouse(this.calcLiquidHeights(false), checkY)) != -1) {
            return this.tank.getFluidInTank(index);
        }
        return null;
    }

    public static int[] calcLiquidHeights(List<FluidStack> liquids, int capacity, int height, int min) {
        int[] fluidHeights = new int[liquids.size()];
        int totalFluidAmount = 0;
        if (liquids.size() > 0) {
            int sum;
            for (int i = 0; i < liquids.size(); ++i) {
                FluidStack liquid = liquids.get(i);
                float h = (float)liquid.getAmount() / (float)capacity;
                totalFluidAmount += liquid.getAmount();
                fluidHeights[i] = Math.max(min, (int)Math.ceil(h * (float)height));
            }
            if (totalFluidAmount < capacity) {
                height -= min;
            }
            do {
                sum = 0;
                int biggest = -1;
                int m = 0;
                for (int i = 0; i < fluidHeights.length; ++i) {
                    sum += fluidHeights[i];
                    if (fluidHeights[i] <= biggest) continue;
                    biggest = fluidHeights[i];
                    m = i;
                }
                if (fluidHeights[m] == 0) break;
                if (sum <= height) continue;
                int n = m;
                fluidHeights[n] = fluidHeights[n] - 1;
            } while (sum > height);
        }
        return fluidHeights;
    }

    public GuiSmelteryTank(ContainerScreen<?> parent, SmelteryTank tank, int x, int y, int width, int height) {
        this.parent = parent;
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
}

