/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.inventory;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.inventory.MultiModuleContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.client.inventory.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiFuelModule;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiMeltingModule;
import slimeknights.tconstruct.smeltery.client.inventory.module.GuiSmelteryTank;
import slimeknights.tconstruct.smeltery.client.inventory.module.HeatingStructureSideInventoryScreen;
import slimeknights.tconstruct.smeltery.inventory.HeatingStructureContainer;
import slimeknights.tconstruct.smeltery.tileentity.controller.HeatingStructureTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.FuelModule;

public class HeatingStructureScreen
extends MultiModuleScreen<HeatingStructureContainer>
implements IScreenWithFluidTank {
    public static final ResourceLocation BACKGROUND = TConstruct.getResource("textures/gui/smeltery.png");
    private static final ElementScreen SCALA = new ElementScreen(176, 76, 52, 52, 256, 256);
    private final HeatingStructureSideInventoryScreen sideInventory;
    private final HeatingStructureTileEntity te;
    private final GuiSmelteryTank tank;
    public final GuiMeltingModule melting;
    private final GuiFuelModule fuel;

    public HeatingStructureScreen(HeatingStructureContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((MultiModuleContainer)container, playerInventory, title);
        HeatingStructureTileEntity te = (HeatingStructureTileEntity)container.getTile();
        if (te != null) {
            this.te = te;
            this.tank = new GuiSmelteryTank((ContainerScreen<?>)this, te.getTank(), 8, 16, HeatingStructureScreen.SCALA.w, HeatingStructureScreen.SCALA.h);
            int slots = te.getMeltingInventory().getSlots();
            this.sideInventory = new HeatingStructureSideInventoryScreen(this, container.getSideInventory(), playerInventory, slots, HeatingStructureContainer.calcColumns(slots));
            this.addModule(this.sideInventory);
            FuelModule fuelModule = te.getFuelModule();
            this.melting = new GuiMeltingModule((ContainerScreen<?>)this, te.getMeltingInventory(), fuelModule::getTemperature, this.sideInventory::shouldDrawSlot);
            this.fuel = new GuiFuelModule((ContainerScreen<?>)this, fuelModule, 71, 32, 12, 36, 70, 15, false);
        } else {
            this.te = null;
            this.tank = null;
            this.melting = null;
            this.fuel = null;
            this.sideInventory = null;
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.te == null || !((Boolean)this.te.func_195044_w().func_177229_b((Property)ControllerBlock.IN_STRUCTURE)).booleanValue() || this.te.getMeltingInventory().getSlots() != this.sideInventory.getSlotCount()) {
            this.func_231175_as__();
        }
    }

    protected void func_230450_a_(MatrixStack matrices, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.drawBackground(matrices, this, BACKGROUND);
        super.func_230450_a_(matrices, partialTicks, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.renderFluids(matrices);
        }
        if (this.fuel != null) {
            this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND);
            this.fuel.draw(matrices);
        }
    }

    protected void func_230451_b_(MatrixStack matrices, int mouseX, int mouseY) {
        super.func_230451_b_(matrices, mouseX, mouseY);
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SCALA.draw(matrices, 8, 16);
        if (this.tank != null) {
            this.tank.renderHighlight(matrices, mouseX, mouseY);
        }
        if (this.fuel != null) {
            this.fuel.renderHighlight(matrices, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        if (this.melting != null) {
            this.melting.drawHeatBars(matrices);
        }
    }

    protected void func_230459_a_(MatrixStack matrices, int mouseX, int mouseY) {
        super.func_230459_a_(matrices, mouseX, mouseY);
        if (this.tank != null) {
            this.tank.drawTooltip(matrices, mouseX, mouseY);
        }
        if (this.fuel != null) {
            boolean hasTank = false;
            if (this.te.getStructure() != null) {
                hasTank = this.te.getStructure().hasTanks();
            }
            this.fuel.addTooltip(matrices, mouseX, mouseY, hasTank);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.tank != null) {
            this.tank.handleClick((int)mouseX - this.cornerX, (int)mouseY - this.cornerY);
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse(double mouseX, double mouseY) {
        FluidStack ingredient = null;
        int checkX = (int)mouseX - this.cornerX;
        int checkY = (int)mouseY - this.cornerY;
        if (this.fuel != null) {
            ingredient = this.fuel.getIngredient(checkX, checkY);
        }
        if (this.tank != null && ingredient == null) {
            ingredient = this.tank.getIngredient(checkX, checkY);
        }
        return ingredient;
    }
}

