/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.modifiers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.plugin.jei.JEIPlugin;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.modifiers.ModifierIngredientRenderer;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.CreativeSlotItem;

public class ModifierRecipeCategory
implements IRecipeCategory<IDisplayModifierRecipe> {
    protected static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/tinker_station.png");
    private static final String KEY_TITLE = TConstruct.makeTranslationKey("jei", "modifiers.title");
    private static final List<ITextComponent> TEXT_FREE = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.free"));
    private static final List<ITextComponent> TEXT_INCREMENTAL = Collections.singletonList(TConstruct.makeTranslation("jei", "modifiers.incremental"));
    private static final String KEY_SLOT = TConstruct.makeTranslationKey("jei", "modifiers.slot");
    private static final String KEY_SLOTS = TConstruct.makeTranslationKey("jei", "modifiers.slots");
    private static final String KEY_MAX = TConstruct.makeTranslationKey("jei", "modifiers.max");
    private final ModifierIngredientRenderer modifierRenderer = new ModifierIngredientRenderer(124);
    private final IDrawable background;
    private final IDrawable icon;
    private final String title;
    private final String maxPrefix;
    private final IDrawable requirements;
    private final IDrawable incremental;
    private final IDrawable[] slotIcons;
    private final Map<SlotType, TextureAtlasSprite> slotTypeSprites = new HashMap<SlotType, TextureAtlasSprite>();

    public ModifierRecipeCategory(IGuiHelper helper) {
        this.title = ForgeI18n.getPattern((String)KEY_TITLE);
        this.maxPrefix = ForgeI18n.getPattern((String)KEY_MAX);
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 0, 128, 77);
        this.icon = helper.createDrawableIngredient((Object)CreativeSlotItem.withSlot(new ItemStack(TinkerModifiers.creativeSlotItem), SlotType.UPGRADE));
        this.slotIcons = new IDrawable[6];
        for (int i = 0; i < 6; ++i) {
            this.slotIcons[i] = helper.createDrawable(BACKGROUND_LOC, 128 + i * 16, 0, 16, 16);
        }
        this.requirements = helper.createDrawable(BACKGROUND_LOC, 128, 17, 16, 16);
        this.incremental = helper.createDrawable(BACKGROUND_LOC, 128, 33, 16, 16);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.modifiers;
    }

    public Class<? extends IDisplayModifierRecipe> getRecipeClass() {
        return IDisplayModifierRecipe.class;
    }

    public void setIngredients(IDisplayModifierRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getDisplayItems());
        ingredients.setOutput(JEIPlugin.MODIFIER_TYPE, (Object)recipe.getDisplayResult());
    }

    private void drawSlot(MatrixStack matrices, List<List<ItemStack>> inputs, int slot, int x, int y) {
        if (slot >= inputs.size() || inputs.get(slot).isEmpty()) {
            this.slotIcons[slot - 1].draw(matrices, x + 1, y + 1);
        }
    }

    private void drawSlotType(MatrixStack matrices, @Nullable SlotType slotType, int x, int y) {
        TextureAtlasSprite sprite;
        Minecraft minecraft = Minecraft.func_71410_x();
        if (this.slotTypeSprites.containsKey(slotType)) {
            sprite = this.slotTypeSprites.get(slotType);
        } else {
            ModelManager modelManager = minecraft.func_209506_al();
            IBakedModel model = minecraft.func_175599_af().func_175037_a().func_199312_b((Item)TinkerModifiers.creativeSlotItem.get());
            if (model != null && model.func_188617_f() instanceof NBTKeyModel.Overrides) {
                RenderMaterial material = ((NBTKeyModel.Overrides)model.func_188617_f()).getTexture(slotType == null ? "slotless" : slotType.getName());
                sprite = modelManager.func_229356_a_(material.func_229310_a_()).func_195424_a(material.func_229313_b_());
            } else {
                sprite = modelManager.func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(MissingTextureSprite.func_195675_b());
            }
            this.slotTypeSprites.put(slotType, sprite);
        }
        minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        Screen.func_238470_a_((MatrixStack)matrices, (int)x, (int)y, (int)0, (int)16, (int)16, (TextureAtlasSprite)sprite);
    }

    public void draw(IDisplayModifierRecipe recipe, MatrixStack matrices, double mouseX, double mouseY) {
        SlotType.SlotCount slots;
        List<List<ItemStack>> inputs = recipe.getDisplayItems();
        this.drawSlot(matrices, inputs, 1, 2, 32);
        this.drawSlot(matrices, inputs, 2, 24, 14);
        this.drawSlot(matrices, inputs, 3, 46, 32);
        this.drawSlot(matrices, inputs, 4, 42, 57);
        this.drawSlot(matrices, inputs, 5, 6, 57);
        if (recipe.hasRequirements()) {
            this.requirements.draw(matrices, 66, 58);
        }
        if (recipe.isIncremental()) {
            this.incremental.draw(matrices, 83, 59);
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int max = recipe.getMaxLevel();
        if (max > 0) {
            fontRenderer.func_238421_b_(matrices, this.maxPrefix + max, 66.0f, 16.0f, Color.GRAY.getRGB());
        }
        if ((slots = recipe.getSlots()) == null) {
            this.drawSlotType(matrices, null, 110, 58);
        } else {
            this.drawSlotType(matrices, slots.getType(), 110, 58);
            String text = Integer.toString(slots.getCount());
            int x = 111 - fontRenderer.func_78256_a(text);
            fontRenderer.func_238421_b_(matrices, text, (float)x, 63.0f, Color.GRAY.getRGB());
        }
    }

    public List<ITextComponent> getTooltipStrings(IDisplayModifierRecipe recipe, double mouseX, double mouseY) {
        int checkX = (int)mouseX;
        int checkY = (int)mouseY;
        if (recipe.hasRequirements() && GuiUtil.isHovered(checkX, checkY, 66, 58, 16, 16)) {
            return Collections.singletonList(new TranslationTextComponent(recipe.getRequirementsError()));
        }
        if (recipe.isIncremental() && GuiUtil.isHovered(checkX, checkY, 83, 59, 16, 16)) {
            return TEXT_INCREMENTAL;
        }
        if (GuiUtil.isHovered(checkX, checkY, 98, 58, 24, 16)) {
            SlotType.SlotCount slots = recipe.getSlots();
            if (slots != null) {
                int count = slots.getCount();
                if (count == 1) {
                    return Collections.singletonList(new TranslationTextComponent(KEY_SLOT, new Object[]{slots.getType().getDisplayName()}));
                }
                if (count > 1) {
                    return Collections.singletonList(new TranslationTextComponent(KEY_SLOTS, new Object[]{slots, slots.getType().getDisplayName()}));
                }
            } else {
                return TEXT_FREE;
            }
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayout layout, IDisplayModifierRecipe recipe, IIngredients ingredients) {
        Item item;
        IGuiIngredientGroup modifiers = layout.getIngredientsGroup(JEIPlugin.MODIFIER_TYPE);
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 24, 37);
        items.init(1, true, 2, 32);
        items.init(2, true, 24, 14);
        items.init(3, true, 46, 32);
        items.init(4, true, 42, 57);
        items.init(5, true, 6, 57);
        items.set(ingredients);
        items.init(-1, false, 104, 33);
        IFocus focus = layout.getFocus(VanillaTypes.ITEM);
        List<ItemStack> output = recipe.getToolWithModifier();
        items.set(-1, output);
        if (focus != null && (item = ((ItemStack)focus.getValue()).func_77973_b()).func_206844_a(TinkerTags.Items.MODIFIABLE)) {
            List<List<ItemStack>> allItems = recipe.getDisplayItems();
            if (allItems.size() >= 1) {
                allItems.get(0).stream().filter(stack -> stack.func_77973_b() == item).findFirst().ifPresent(stack -> items.set(0, stack));
            }
            output.stream().filter(stack -> stack.func_77973_b() == item).findFirst().ifPresent(stack -> items.set(-1, stack));
        }
        modifiers.init(6, false, (IIngredientRenderer)this.modifierRenderer, 2, 2, 124, 10, 0, 0);
        modifiers.set(ingredients);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }
}

