/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ForgeI18n;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.FluidTooltipHandler;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructRecipeCategoryUid;
import slimeknights.tconstruct.plugin.jei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class FoundryCategory
extends AbstractMeltingCategory {
    private static final String KEY_TITLE = TConstruct.makeTranslationKey("jei", "foundry.title");
    private static final ITooltipCallback<FluidStack> FLUID_TOOLTIP = new MeltingFluidCallback(false);
    private static final ITooltipCallback<FluidStack> ORE_FLUID_TOOLTIP = new MeltingFluidCallback(true);
    private final String title;
    private final IDrawable icon;

    public FoundryCategory(IGuiHelper helper) {
        super(helper);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack(TinkerSmeltery.foundryController));
        this.title = ForgeI18n.getPattern((String)KEY_TITLE);
    }

    public ResourceLocation getUid() {
        return TConstructRecipeCategoryUid.foundry;
    }

    @Override
    public void setIngredients(MeltingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutputLists(VanillaTypes.FLUID, recipe.getOutputWithByproducts());
    }

    public void setRecipe(IRecipeLayout layout, MeltingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup items = layout.getItemStacks();
        items.init(0, true, 23, 17);
        items.set(ingredients);
        IGuiFluidStackGroup fluids = layout.getFluidStacks();
        AlloyRecipeCategory.drawVariableFluids(fluids, 0, false, 96, 4, 32, 32, recipe.getOutputWithByproducts(), 1296);
        fluids.set(ingredients);
        fluids.init(-1, true, 4, 4, 12, 32, 1, false, null);
        fluids.set(-1, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
        fluids.addTooltipCallback(recipe.isOre() ? ORE_FLUID_TOOLTIP : FLUID_TOOLTIP);
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        public MeltingFluidCallback(boolean isOre) {
            super(isOre);
        }

        @Override
        protected boolean addOreTooltip(FluidStack stack, List<ITextComponent> list) {
            return FluidTooltipHandler.appendMaterialNoShift(stack.getFluid(), IMeltingInventory.applyOreBoost(stack.getAmount(), (Integer)Config.COMMON.foundryNuggetsPerOre.get()), list);
        }
    }
}

