/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;

public class LayoutSlot {
    public static final LayoutSlot EMPTY = new LayoutSlot(null, "", -1, -1, null);
    @Nullable
    private final Pattern icon;
    @Nullable
    private final String translation_key;
    private final int x;
    private final int y;
    @Nullable
    @VisibleForTesting
    private final Ingredient filter;

    public boolean isEmpty() {
        return this.getTranslationKey().isEmpty();
    }

    public boolean isHidden() {
        return this.x == -1 && this.y == -1;
    }

    public String getTranslationKey() {
        return (String)LogicHelper.defaultIfNull((Object)this.translation_key, (Object)"");
    }

    public boolean isValid(ItemStack stack) {
        return !stack.func_190926_b() && (this.filter == null || this.filter.test(stack));
    }

    public static LayoutSlot read(PacketBuffer buffer) {
        Pattern pattern = null;
        if (buffer.readBoolean()) {
            pattern = new Pattern(buffer.func_192575_l());
        }
        String name = buffer.func_150789_c(Short.MAX_VALUE);
        int x = buffer.func_150792_a();
        int y = buffer.func_150792_a();
        Ingredient ingredient = null;
        if (buffer.readBoolean()) {
            ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        }
        return new LayoutSlot(pattern, name, x, y, ingredient);
    }

    public void write(PacketBuffer buffer) {
        if (this.icon != null) {
            buffer.writeBoolean(true);
            buffer.func_192572_a((ResourceLocation)this.icon);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.func_180714_a(this.getTranslationKey());
        buffer.func_150787_b(this.x);
        buffer.func_150787_b(this.y);
        if (this.filter != null) {
            buffer.writeBoolean(true);
            this.filter.func_199564_a(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public LayoutSlot(@Nullable Pattern icon, @Nullable String translation_key, int x, int y, @Nullable Ingredient filter) {
        this.icon = icon;
        this.translation_key = translation_key;
        this.x = x;
        this.y = y;
        this.filter = filter;
    }

    @Nullable
    public Pattern getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nullable
    protected Ingredient getFilter() {
        return this.filter;
    }
}

