/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper.aoe;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.RectangleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TreeAOEHarvestLogic
extends ToolHarvestLogic {
    private static final int MAX_BRANCK_DISTANCE = 10;
    private final int extraWidth;
    private final int extraDepth;
    private final int fallbackHeight;

    @Override
    public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, ToolHarvestLogic.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
        return TreeAOEHarvestLogic.calculate(this, tool, stack, player, state, world, origin, sideHit, this.extraWidth + (expanded + 1) / 2, this.extraDepth + expanded / 2, this.fallbackHeight, matchType);
    }

    public static Iterable<BlockPos> calculate(ToolHarvestLogic self, IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, int extraWidth, int extraDepth, int fallbackHeight, ToolHarvestLogic.AOEMatchType matchType) {
        Direction widthDir;
        Direction depthDir;
        if (extraDepth > 0 || extraWidth > 0) {
            depthDir = sideHit.func_176740_k().func_200128_b() ? player.func_174811_aO() : sideHit.func_176734_d();
            widthDir = depthDir.func_176746_e();
        } else {
            depthDir = Direction.UP;
            widthDir = Direction.UP;
        }
        if (state.func_177230_c().func_203417_a(TinkerTags.Blocks.TREE_LOGS)) {
            return () -> new TreeIterator(world, state.func_177230_c(), origin, widthDir, extraWidth, depthDir, extraDepth);
        }
        Predicate<BlockPos> posPredicate = TreeAOEHarvestLogic.getDefaultBlockPredicate(self, tool, stack, world, origin, matchType);
        return () -> new RectangleAOEHarvestLogic.RectangleIterator(origin, widthDir, extraWidth, Direction.UP, fallbackHeight, false, depthDir, extraDepth, posPredicate);
    }

    public TreeAOEHarvestLogic(int extraWidth, int extraDepth, int fallbackHeight) {
        this.extraWidth = extraWidth;
        this.extraDepth = extraDepth;
        this.fallbackHeight = fallbackHeight;
    }

    private static class TreePos {
        private final BlockPos.Mutable pos;
        private final Direction direction;
        private boolean isChecked;

        TreePos(BlockPos pos, boolean isChecked) {
            this.pos = pos.func_239590_i_();
            this.direction = Direction.UP;
            this.isChecked = isChecked;
        }

        TreePos(BlockPos pos, Direction direction) {
            this.pos = pos.func_239590_i_();
            this.direction = direction;
            this.isChecked = true;
        }

        public TreePos move() {
            this.pos.func_189536_c(this.direction);
            this.isChecked = false;
            return this;
        }
    }

    public static class TreeIterator
    extends AbstractIterator<BlockPos> {
        private final Queue<TreePos> upcomingPositions = new ArrayDeque<TreePos>();
        private final BlockPos.Mutable mutable = new BlockPos.Mutable();
        private final Set<BlockPos> branchVisited = new HashSet<BlockPos>();
        private final World world;
        private final Block filter;
        private final int minX;
        private final int maxX;
        private final int minZ;
        private final int maxZ;

        public TreeIterator(World world, Block filter, BlockPos origin, Direction widthDir, int extraWidth, Direction depthDir, int extraDepth) {
            int minZ;
            int minX;
            this.world = world;
            this.filter = filter;
            this.upcomingPositions.add(new TreePos(origin.func_177984_a(), false));
            int maxX = minX = origin.func_177958_n();
            int maxZ = minZ = origin.func_177952_p();
            if (extraDepth > 0 || extraWidth > 0) {
                for (int d = 0; d <= extraDepth; ++d) {
                    for (int w = -extraWidth; w <= extraWidth; ++w) {
                        if (d == 0 && w == 0) continue;
                        this.mutable.func_189533_g((Vector3i)origin).func_189534_c(depthDir, d).func_189534_c(widthDir, w);
                        if (!this.isValidBlock((BlockPos)this.mutable)) continue;
                        this.upcomingPositions.add(new TreePos((BlockPos)this.mutable, true));
                        if (this.mutable.func_177958_n() < minX) {
                            minX = this.mutable.func_177958_n();
                        }
                        if (this.mutable.func_177958_n() > maxX) {
                            maxX = this.mutable.func_177958_n();
                        }
                        if (this.mutable.func_177952_p() < minZ) {
                            minZ = this.mutable.func_177952_p();
                        }
                        if (this.mutable.func_177952_p() <= maxZ) continue;
                        maxZ = this.mutable.func_177952_p();
                    }
                }
            }
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }

        private boolean isValidBlock(BlockPos pos) {
            return this.world.func_180495_p(pos).func_177230_c() == this.filter;
        }

        private boolean outsideTrunk(BlockPos pos) {
            return pos.func_177958_n() < this.minX || pos.func_177958_n() > this.maxX || pos.func_177952_p() < this.minZ || pos.func_177952_p() > this.maxZ;
        }

        private boolean isBranch(BlockPos pos) {
            int deltaZ;
            if (!this.outsideTrunk(pos)) {
                return false;
            }
            int deltaX = Math.min(Math.abs(pos.func_177958_n() - this.minX), Math.abs(pos.func_177958_n() - this.maxX));
            if (deltaX + (deltaZ = Math.min(Math.abs(pos.func_177952_p() - this.minZ), Math.abs(pos.func_177952_p() - this.maxZ))) > 10 || this.branchVisited.contains(pos)) {
                return false;
            }
            this.branchVisited.add(pos.func_185334_h());
            return this.isValidBlock(pos);
        }

        private void addBranch(Direction direction) {
            this.upcomingPositions.add(new TreePos((BlockPos)this.mutable, direction));
        }

        private void tryBranch(Direction direction) {
            if (this.isBranch((BlockPos)this.mutable)) {
                TreePos branchPos = new TreePos((BlockPos)this.mutable, direction);
                if (!this.world.func_180495_p((BlockPos)this.mutable.func_196234_d(0, -1, 0)).func_200132_m()) {
                    this.upcomingPositions.add(branchPos);
                }
            }
        }

        protected BlockPos computeNext() {
            while (!this.upcomingPositions.isEmpty()) {
                TreePos treePos = this.upcomingPositions.remove();
                if (treePos.direction == Direction.UP) {
                    boolean isMaxZ;
                    boolean isTreeUp = treePos.isChecked || this.isValidBlock((BlockPos)treePos.pos);
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        this.mutable.func_189533_g((Vector3i)treePos.pos).func_189536_c(direction);
                        this.tryBranch(!isTreeUp ? Direction.UP : direction);
                    }
                    if (!isTreeUp) continue;
                    boolean isMinX = treePos.pos.func_177958_n() == this.minX;
                    boolean isMaxX = treePos.pos.func_177958_n() == this.maxX;
                    boolean isMinZ = treePos.pos.func_177952_p() == this.minZ;
                    boolean bl = isMaxZ = treePos.pos.func_177952_p() == this.maxZ;
                    if (isMinX) {
                        if (isMinZ) {
                            this.mutable.func_189533_g((Vector3i)treePos.pos).func_196234_d(-1, 0, -1);
                            this.tryBranch(Direction.WEST);
                        }
                        if (isMaxZ) {
                            this.mutable.func_189533_g((Vector3i)treePos.pos).func_196234_d(-1, 0, 1);
                            this.tryBranch(Direction.WEST);
                        }
                    }
                    if (isMaxX) {
                        if (isMinZ) {
                            this.mutable.func_189533_g((Vector3i)treePos.pos).func_196234_d(1, 0, -1);
                            this.tryBranch(Direction.EAST);
                        }
                        if (isMaxZ) {
                            this.mutable.func_189533_g((Vector3i)treePos.pos).func_196234_d(1, 0, 1);
                            this.tryBranch(Direction.EAST);
                        }
                    }
                    this.mutable.func_189533_g((Vector3i)treePos.pos);
                    this.upcomingPositions.add(treePos.move());
                    if (this.outsideTrunk((BlockPos)treePos.pos)) {
                        this.branchVisited.add((BlockPos)treePos.pos);
                    }
                    return this.mutable;
                }
                this.mutable.func_189533_g((Vector3i)treePos.pos).func_196234_d(0, 1, 0);
                if (this.isBranch((BlockPos)this.mutable)) {
                    this.addBranch(treePos.direction);
                } else if (this.isBranch((BlockPos)this.mutable.func_189536_c(treePos.direction).func_196234_d(0, -1, 0))) {
                    this.addBranch(treePos.direction);
                } else if (this.isBranch((BlockPos)this.mutable.func_196234_d(0, 1, 0))) {
                    this.addBranch(treePos.direction);
                }
                Direction rotated = treePos.direction.func_176746_e();
                this.mutable.func_189533_g((Vector3i)treePos.pos).func_189536_c(rotated);
                if (this.isBranch((BlockPos)this.mutable)) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.func_196234_d(0, 1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.func_189536_c(treePos.direction).func_196234_d(0, -1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.func_196234_d(0, 1, 0))) {
                    this.addBranch(rotated);
                }
                rotated = rotated.func_176734_d();
                this.mutable.func_189533_g((Vector3i)treePos.pos).func_189536_c(rotated);
                if (this.isBranch((BlockPos)this.mutable)) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.func_196234_d(0, 1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.func_189536_c(treePos.direction).func_196234_d(0, -1, 0))) {
                    this.addBranch(rotated);
                } else if (this.isBranch((BlockPos)this.mutable.func_196234_d(0, 1, 0))) {
                    this.addBranch(rotated);
                }
                return treePos.pos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

