/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class ToolBuildHandler {
    private static final List<MaterialId> RENDER_MATERIALS = Arrays.asList(new MaterialId("tconstruct", "ui_render_head"), new MaterialId("tconstruct", "ui_render_handle"), new MaterialId("tconstruct", "ui_render_extra"), new MaterialId("tconstruct", "ui_render_large"), new MaterialId("tconstruct", "ui_render_extra_large"));

    private ToolBuildHandler() {
    }

    public static ItemStack buildItemFromMaterials(IModifiable tool, List<IMaterial> materials) {
        return ToolStack.createTool(tool.func_199767_j(), tool.getToolDefinition(), materials).createStack();
    }

    public static MaterialId getRenderMaterial(int index) {
        return RENDER_MATERIALS.get(index % RENDER_MATERIALS.size());
    }

    public static ItemStack buildToolForRendering(Item item, ToolDefinition definition) {
        int size = definition.getData().getParts().size();
        ItemStack stack = new ItemStack((IItemProvider)item);
        if (definition.isMultipart()) {
            stack = new MaterialIdNBT(RENDER_MATERIALS).updateStack(stack);
        }
        stack.func_196082_o().func_74757_a("tic_display", true);
        return stack;
    }

    public static List<IMaterial> randomMaterials(ToolDefinitionData data, int maxTier, boolean allowHidden) {
        List<PartRequirement> requirements = data.getParts();
        Map materialChoices = requirements.stream().map(PartRequirement::getStatType).distinct().collect(Collectors.toMap(Function.identity(), t -> new ArrayList()));
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        registry.getAllMaterials().stream().filter(mat -> (allowHidden || !mat.isHidden()) && mat.getTier() <= maxTier).forEach(mat -> {
            for (IMaterialStats stats : registry.getAllStats(mat.getIdentifier())) {
                List list = (List)materialChoices.get((Object)stats.getIdentifier());
                if (list == null) continue;
                list.add(mat);
            }
        });
        ImmutableList.Builder materials = ImmutableList.builder();
        for (PartRequirement requirement : requirements) {
            List choices = materialChoices.get((Object)requirement.getStatType());
            if (choices == null || choices.isEmpty()) {
                materials.add((Object)IMaterial.UNKNOWN);
                TConstruct.LOG.error("Failed to find a {}material of type {} below tier {}", (Object)(allowHidden ? "non-hidden " : ""), (Object)requirement.getStatType(), (Object)maxTier);
                continue;
            }
            materials.add(choices.get(TConstruct.RANDOM.nextInt(choices.size())));
        }
        return materials.build();
    }

    public static void addDefaultSubItems(IModifiable item, List<ItemStack> itemList, IMaterial ... fixedMaterials) {
        block3: {
            IMaterial material2;
            MaterialId materialId;
            block4: {
                boolean isMultipart;
                block2: {
                    ToolDefinition definition = item.getToolDefinition();
                    isMultipart = definition.isMultipart();
                    if (definition.isDataLoaded() && (!isMultipart || MaterialRegistry.isFullyLoaded())) break block2;
                    itemList.add(new ItemStack((IItemProvider)item));
                    break block3;
                }
                if (isMultipart) break block4;
                itemList.add(ToolBuildHandler.buildItemFromMaterials(item, Collections.emptyList()));
                break block3;
            }
            String showOnlyId = (String)Config.COMMON.showOnlyToolMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryCreate(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && ToolBuildHandler.addSubItem(item, itemList, material2, fixedMaterials)) {
                added = true;
            }
            if (added) break block3;
            for (IMaterial material2 : MaterialRegistry.getInstance().getVisibleMaterials()) {
                if (ToolBuildHandler.addSubItem(item, itemList, material2, fixedMaterials) && !showOnlyId.isEmpty()) break;
            }
        }
    }

    private static boolean addSubItem(IModifiable item, List<ItemStack> items, IMaterial material, IMaterial[] fixedMaterials) {
        List<PartRequirement> required = item.getToolDefinition().getData().getParts();
        ArrayList<IMaterial> materials = new ArrayList<IMaterial>(required.size());
        for (int i = 0; i < required.size(); ++i) {
            if (fixedMaterials.length > i && fixedMaterials[i] != null && required.get(i).canUseMaterial(fixedMaterials[i])) {
                materials.add(fixedMaterials[i]);
                continue;
            }
            if (required.get(i).canUseMaterial(material)) {
                materials.add(material);
                continue;
            }
            return false;
        }
        items.add(ToolBuildHandler.buildItemFromMaterials(item, materials));
        return true;
    }
}

