/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;

public class UpdateToolDefinitionDataPacket
implements IThreadsafePacket {
    private final Map<ResourceLocation, ToolDefinitionData> dataMap;

    public UpdateToolDefinitionDataPacket(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            ResourceLocation name = buffer.func_192575_l();
            ToolDefinitionData data = ToolDefinitionData.read(buffer);
            builder.put((Object)name, (Object)data);
        }
        this.dataMap = builder.build();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.dataMap.size());
        for (Map.Entry<ResourceLocation, ToolDefinitionData> entry : this.dataMap.entrySet()) {
            buffer.func_192572_a(entry.getKey());
            entry.getValue().write(buffer);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ToolDefinitionLoader.getInstance().updateDataFromServer(this.dataMap);
    }

    public UpdateToolDefinitionDataPacket(Map<ResourceLocation, ToolDefinitionData> dataMap) {
        this.dataMap = dataMap;
    }

    protected Map<ResourceLocation, ToolDefinitionData> getDataMap() {
        return this.dataMap;
    }
}

