/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.SyncPersistentDataPacket;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class PersistentDataCapability
implements Capability.IStorage<NamespacedNBT> {
    private static final ResourceLocation ID = TConstruct.getResource("persistent_data");
    private static final PersistentDataCapability INSTANCE = new PersistentDataCapability();
    @CapabilityInject(value=NamespacedNBT.class)
    public static Capability<NamespacedNBT> CAPABILITY = null;

    private PersistentDataCapability() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(NamespacedNBT.class, (Capability.IStorage)INSTANCE, NamespacedNBT::new);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, PersistentDataCapability::attachCapability);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.Clone.class, PersistentDataCapability::playerClone);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerRespawnEvent.class, PersistentDataCapability::playerRespawn);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerChangedDimensionEvent.class, PersistentDataCapability::playerChangeDimension);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedInEvent.class, PersistentDataCapability::playerLoggedIn);
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            Provider provider = new Provider();
            event.addCapability(ID, (ICapabilityProvider)provider);
            event.addListener((Runnable)provider);
        }
    }

    private static void sync(PlayerEntity player) {
        player.getCapability(CAPABILITY).ifPresent(data -> TinkerNetwork.getInstance().sendTo(new SyncPersistentDataPacket(data.getCopy()), player));
    }

    private static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().getCapability(CAPABILITY).ifPresent(oldData -> {
            CompoundNBT nbt = oldData.getCopy();
            if (!nbt.isEmpty()) {
                event.getPlayer().getCapability(CAPABILITY).ifPresent(newData -> newData.copyFrom(nbt));
            }
        });
    }

    private static void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PersistentDataCapability.sync(event.getPlayer());
    }

    private static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PersistentDataCapability.sync(event.getPlayer());
    }

    private static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PersistentDataCapability.sync(event.getPlayer());
    }

    @Nullable
    public INBT writeNBT(Capability<NamespacedNBT> capability, NamespacedNBT instance, Direction side) {
        return null;
    }

    public void readNBT(Capability<NamespacedNBT> capability, NamespacedNBT instance, Direction side, INBT nbt) {
    }

    private static class Provider
    implements ICapabilitySerializable<CompoundNBT>,
    Runnable {
        private Lazy<CompoundNBT> nbt = Lazy.of(CompoundNBT::new);
        private LazyOptional<NamespacedNBT> capability = LazyOptional.of(() -> NamespacedNBT.readFromNBT((CompoundNBT)this.nbt.get()));

        private Provider() {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.capability);
        }

        @Override
        public void run() {
            this.capability.invalidate();
            this.capability = LazyOptional.of(() -> NamespacedNBT.readFromNBT((CompoundNBT)this.nbt.get()));
        }

        public CompoundNBT serializeNBT() {
            return ((CompoundNBT)this.nbt.get()).func_74737_b();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.nbt = Lazy.of(() -> nbt);
            this.run();
        }
    }
}

