/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairRecipeBuilder
extends AbstractRecipeBuilder<ModifierRepairRecipeBuilder> {
    private final Modifier modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.modifier.getId());
    }

    public ModifierRepairRecipeBuilder buildCraftingTable(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId, (IRecipeSerializer)TinkerModifiers.craftingModifierRepair.get()));
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "tinker_station");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId, (IRecipeSerializer)TinkerModifiers.modifierRepair.get()));
    }

    private ModifierRepairRecipeBuilder(Modifier modifier, Ingredient ingredient, int repairAmount) {
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    public static ModifierRepairRecipeBuilder repair(Modifier modifier, Ingredient ingredient, int repairAmount) {
        return new ModifierRepairRecipeBuilder(modifier, ingredient, repairAmount);
    }

    private class FinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        private final IRecipeSerializer<?> serializer;

        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID, IRecipeSerializer<?> serializer) {
            super((AbstractRecipeBuilder)ModifierRepairRecipeBuilder.this, ID, advancementID);
            this.serializer = serializer;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("modifier", ModifierRepairRecipeBuilder.this.modifier.getId().toString());
            json.add("ingredient", ModifierRepairRecipeBuilder.this.ingredient.func_200304_c());
            json.addProperty("repair_amount", (Number)ModifierRepairRecipeBuilder.this.repairAmount);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }
    }
}

