/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.EntityIngredient;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;

public class DamageSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    @Nullable
    private final EntityIngredient entity;
    private final LivingEntityPredicate predicate;
    private final DamageType type;
    private final float damage;

    public DamageSpillingEffect(EntityIngredient entity, DamageType type, float damage) {
        this(entity, LivingEntityPredicate.ANY, type, damage);
    }

    public DamageSpillingEffect(LivingEntityPredicate entity, DamageType type, float damage) {
        this(null, entity, type, damage);
    }

    public DamageSpillingEffect(DamageType type, float damage) {
        this(LivingEntityPredicate.ANY, type, damage);
    }

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        Entity target = context.getTarget();
        LivingEntity livingTarget = context.getLivingTarget();
        if ((this.entity == null || this.entity.test((Object)target.func_200600_R())) && (livingTarget == null ? this.predicate == LivingEntityPredicate.ANY : this.predicate.test(livingTarget))) {
            PlayerEntity player = context.getPlayerAttacker();
            DamageSource source = player != null ? DamageSource.func_76365_a((PlayerEntity)player) : DamageSource.func_76358_a((LivingEntity)context.getAttacker());
            this.type.apply(source);
            ToolAttackUtil.attackEntitySecondary(source, this.damage * scale, context.getTarget(), livingTarget, true);
        }
    }

    @Override
    public ISpillingEffectLoader<?> getLoader() {
        return LOADER;
    }

    protected DamageSpillingEffect(@Nullable EntityIngredient entity, LivingEntityPredicate predicate, DamageType type, float damage) {
        this.entity = entity;
        this.predicate = predicate;
        this.type = type;
        this.damage = damage;
    }

    private static class Loader
    implements ISpillingEffectLoader<DamageSpillingEffect> {
        private Loader() {
        }

        @Override
        public DamageSpillingEffect deserialize(JsonObject json) {
            String typeName;
            DamageType type;
            EntityIngredient entity = null;
            LivingEntityPredicate predicate = LivingEntityPredicate.ANY;
            if (json.has("entity")) {
                JsonElement element = JsonHelper.getElement((JsonObject)json, (String)"entity");
                if (element.isJsonPrimitive()) {
                    predicate = LivingEntityPredicate.byName(element.getAsString());
                    if (predicate == null) {
                        throw new JsonSyntaxException("Invalid entity predicate " + element.getAsString());
                    }
                } else {
                    entity = EntityIngredient.deserialize((JsonElement)element);
                }
            }
            if ((type = DamageType.byName(typeName = JSONUtils.func_151200_h((JsonObject)json, (String)"damage_type"))) == null) {
                throw new JsonSyntaxException("Unknown damage type '" + typeName + "'");
            }
            float damage = JSONUtils.func_151217_k((JsonObject)json, (String)"damage_amount");
            return new DamageSpillingEffect(entity, predicate, type, damage);
        }

        @Override
        public DamageSpillingEffect read(PacketBuffer buffer) {
            EntityIngredient entity = null;
            if (buffer.readBoolean()) {
                entity = EntityIngredient.read((PacketBuffer)buffer);
            }
            LivingEntityPredicate predicate = (LivingEntityPredicate)buffer.func_179257_a(LivingEntityPredicate.class);
            DamageType type = (DamageType)buffer.func_179257_a(DamageType.class);
            float damage = buffer.readFloat();
            return new DamageSpillingEffect(entity, predicate, type, damage);
        }

        @Override
        public void serialize(DamageSpillingEffect effect, JsonObject json) {
            if (effect.entity != null) {
                json.add("entity", effect.entity.serialize());
            } else if (effect.predicate != LivingEntityPredicate.ANY) {
                json.addProperty("entity", effect.predicate.getName());
            }
            json.addProperty("damage_type", effect.type.getName());
            json.addProperty("damage_amount", (Number)Float.valueOf(effect.damage));
        }

        @Override
        public void write(DamageSpillingEffect effect, PacketBuffer buffer) {
            if (effect.entity != null) {
                buffer.writeBoolean(true);
                effect.entity.write(buffer);
            } else {
                buffer.writeBoolean(false);
            }
            buffer.func_179249_a((Enum)effect.predicate);
            buffer.func_179249_a((Enum)effect.type);
            buffer.writeFloat(effect.damage);
        }
    }

    public static enum LivingEntityPredicate {
        ANY{

            @Override
            public boolean test(LivingEntity living) {
                return true;
            }
        }
        ,
        WATER_SENSITIVE{

            @Override
            public boolean test(LivingEntity living) {
                return living.func_230270_dK_();
            }
        }
        ,
        UNDEAD{

            @Override
            public boolean test(LivingEntity living) {
                return living.func_70668_bt() == CreatureAttribute.field_223223_b_;
            }
        }
        ,
        ARTHROPOD{

            @Override
            public boolean test(LivingEntity living) {
                return living.func_70668_bt() == CreatureAttribute.field_223224_c_;
            }
        }
        ,
        NOT_FIRE_IMMUNE{

            @Override
            public boolean test(LivingEntity living) {
                return !living.func_230279_az_();
            }
        };

        private final String name = this.name().toLowerCase(Locale.US);

        public abstract boolean test(LivingEntity var1);

        @Nullable
        public static LivingEntityPredicate byName(String name) {
            for (LivingEntityPredicate type : LivingEntityPredicate.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum DamageType {
        NORMAL{

            @Override
            public void apply(DamageSource source) {
            }
        }
        ,
        FIRE{

            @Override
            public void apply(DamageSource source) {
                source.func_76361_j();
            }
        }
        ,
        MAGIC{

            @Override
            public void apply(DamageSource source) {
                source.func_82726_p();
            }
        }
        ,
        EXPLOSION{

            @Override
            public void apply(DamageSource source) {
                source.func_94540_d();
            }
        }
        ,
        PIERCING{

            @Override
            public void apply(DamageSource source) {
                source.func_76348_h();
            }
        };

        private final String name = this.name().toLowerCase(Locale.US);

        public abstract void apply(DamageSource var1);

        @Nullable
        public static DamageType byName(String name) {
            for (DamageType type : DamageType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

