/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.SpillingRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class SpillingRecipeBuilder
extends AbstractRecipeBuilder<SpillingRecipeBuilder> {
    private final FluidIngredient fluid;
    private final List<ISpillingEffect> effects = new ArrayList<ISpillingEffect>();

    public static SpillingRecipeBuilder forFluid(FluidStack fluid) {
        return new SpillingRecipeBuilder(FluidIngredient.of((FluidStack)fluid));
    }

    public static SpillingRecipeBuilder forFluid(Fluid fluid, int amount) {
        return new SpillingRecipeBuilder(FluidIngredient.of((Fluid)fluid, (int)amount));
    }

    public static SpillingRecipeBuilder forFluid(ITag<Fluid> fluid, int amount) {
        return new SpillingRecipeBuilder(FluidIngredient.of(fluid, (int)amount));
    }

    public SpillingRecipeBuilder addEffect(ISpillingEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, Objects.requireNonNull(((FluidStack)this.fluid.getFluids().get(0)).getFluid().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.effects.isEmpty()) {
            throw new IllegalStateException("Must have at least one effect to build");
        }
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, null));
    }

    private SpillingRecipeBuilder(FluidIngredient fluid) {
        this.fluid = fluid;
    }

    public static SpillingRecipeBuilder forFluid(FluidIngredient fluid) {
        return new SpillingRecipeBuilder(fluid);
    }

    private class FinishedRecipe
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)SpillingRecipeBuilder.this, ID, advancementID);
        }

        public void func_218610_a(JsonObject json) {
            json.add("fluid", SpillingRecipeBuilder.this.fluid.serialize());
            JsonArray effectArray = new JsonArray();
            for (ISpillingEffect effect : SpillingRecipeBuilder.this.effects) {
                effectArray.add((JsonElement)SpillingRecipeLookup.serializeEffect(effect));
            }
            json.add("effects", (JsonElement)effectArray);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerModifiers.spillingSerializer.get();
        }
    }
}

