/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<IncrementalModifierRecipeBuilder> {
    private Ingredient input = Ingredient.field_193370_a;
    private ItemOutput salvage = null;
    private int amountPerItem;
    private int neededPerLevel;
    private ItemStack leftover = ItemStack.field_190927_a;
    private boolean fullSalvage = false;

    protected IncrementalModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static IncrementalModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new IncrementalModifierRecipeBuilder(modifier);
    }

    public static IncrementalModifierRecipeBuilder modifier(Modifier modifier) {
        return IncrementalModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public IncrementalModifierRecipeBuilder setInput(Ingredient input, int amountPerItem, int neededPerLevel) {
        if (amountPerItem < 1) {
            throw new IllegalArgumentException("Amount per item must be at least 1");
        }
        if (neededPerLevel <= amountPerItem) {
            throw new IllegalArgumentException("Needed per level must be greater than amount per item");
        }
        this.input = input;
        this.amountPerItem = amountPerItem;
        this.neededPerLevel = neededPerLevel;
        return this;
    }

    public IncrementalModifierRecipeBuilder setInput(IItemProvider item, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setInput(ITag<Item> tag, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.func_199805_a(tag), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setSalvage(ItemOutput salvage, boolean fullOutput) {
        this.salvage = salvage;
        this.fullSalvage = fullOutput;
        return this;
    }

    public IncrementalModifierRecipeBuilder setSalvage(IItemProvider item, int amountPerItem, boolean fullOutput) {
        this.setSalvage(ItemOutput.fromStack((ItemStack)new ItemStack(item, amountPerItem)), fullOutput);
        return this;
    }

    public IncrementalModifierRecipeBuilder setSalvage(IItemProvider item, boolean fullOutput) {
        return this.setSalvage(item, 1, fullOutput);
    }

    public IncrementalModifierRecipeBuilder setInputSalvage(IItemProvider item, int amountPerItem, int neededPerLevel, boolean fullOutput) {
        this.setInput(item, amountPerItem, neededPerLevel);
        this.setSalvage(item, amountPerItem, fullOutput);
        return this;
    }

    public IncrementalModifierRecipeBuilder setInputSalvage(ITag<Item> tag, int amountPerItem, int neededPerLevel, boolean fullOutput) {
        this.setInput(tag, amountPerItem, neededPerLevel);
        this.setSalvage(ItemOutput.fromTag(tag, (int)amountPerItem), fullOutput);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.input == Ingredient.field_193370_a) {
            throw new IllegalStateException("Must set input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((IFinishedRecipe)new FinishedRecipe(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((IFinishedRecipe)new FinishedRecipe(new ResourceLocation(id.func_110624_b(), id.func_110623_a() + "_unarmed"), null, true));
        }
    }

    @Override
    public IncrementalModifierRecipeBuilder buildSalvage(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.salvageMaxLevel != 0 && this.salvageMaxLevel < this.salvageMinLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((IFinishedRecipe)new FinishedSalvage(id, advancementId));
        return this;
    }

    public static JsonElement serializeResult(ItemStack result) {
        String itemName = Objects.requireNonNull(result.func_77973_b().getRegistryName()).toString();
        if (result.func_77942_o()) {
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", itemName);
            int count = result.func_190916_E();
            if (count > 1) {
                jsonResult.addProperty("count", (Number)count);
            }
            jsonResult.addProperty("nbt", Objects.requireNonNull(result.func_77978_p()).toString());
            return jsonResult;
        }
        return new JsonPrimitive(itemName);
    }

    public IncrementalModifierRecipeBuilder setLeftover(ItemStack leftover) {
        this.leftover = leftover;
        return this;
    }

    private class FinishedSalvage
    extends AbstractModifierRecipeBuilder.SalvageFinishedRecipe {
        public FinishedSalvage(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super(IncrementalModifierRecipeBuilder.this, ID, advancementID);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            if (IncrementalModifierRecipeBuilder.this.salvage != null) {
                JsonObject salvageObject;
                JsonElement salvageElement = IncrementalModifierRecipeBuilder.this.salvage.serialize();
                if (salvageElement.isJsonObject()) {
                    salvageObject = salvageElement.getAsJsonObject();
                } else {
                    salvageObject = new JsonObject();
                    salvageObject.add("item", salvageElement);
                    salvageObject.addProperty("full", Boolean.valueOf(IncrementalModifierRecipeBuilder.this.fullSalvage));
                }
                json.add("salvage", (JsonElement)salvageObject);
            }
        }

        public IRecipeSerializer<?> func_218609_c() {
            return IncrementalModifierRecipeBuilder.this.salvage == null ? (IRecipeSerializer)TinkerModifiers.modifierSalvageSerializer.get() : (IRecipeSerializer)TinkerModifiers.incrementalModifierSalvageSerializer.get();
        }
    }

    private class FinishedRecipe
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedRecipe(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super(IncrementalModifierRecipeBuilder.this, ID, advancementID, withUnarmed);
        }

        @Override
        public void func_218610_a(JsonObject json) {
            json.add("input", IncrementalModifierRecipeBuilder.this.input.func_200304_c());
            json.addProperty("amount_per_item", (Number)IncrementalModifierRecipeBuilder.this.amountPerItem);
            json.addProperty("needed_per_level", (Number)IncrementalModifierRecipeBuilder.this.neededPerLevel);
            if (IncrementalModifierRecipeBuilder.this.leftover != ItemStack.field_190927_a) {
                json.add("leftover", IncrementalModifierRecipeBuilder.serializeResult(IncrementalModifierRecipeBuilder.this.leftover));
            }
            super.func_218610_a(json);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TinkerModifiers.incrementalModifierSerializer.get();
        }
    }
}

