/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public abstract class ModifierMatch
implements Predicate<List<ModifierEntry>> {
    public static final ModifierMatch ALWAYS = new ListMatch(Collections.emptyList(), 0);

    public static ModifierMatch entry(Modifier modifier, int level) {
        return new EntryMatch(new ModifierEntry(modifier, level));
    }

    public static ModifierMatch entry(Modifier modifier) {
        return new EntryMatch(new ModifierEntry(modifier, 1));
    }

    public static ModifierMatch list(int required, ModifierMatch ... matches) {
        return new ListMatch(Arrays.asList(matches), required);
    }

    public static ModifierMatch deserialize(JsonObject json) {
        if (json.has("options")) {
            int required = JSONUtils.func_151203_m((JsonObject)json, (String)"matches_needed");
            if (required == 0) {
                return ALWAYS;
            }
            List options = JsonHelper.parseList((JsonObject)json, (String)"options", ModifierMatch::deserialize);
            return new ListMatch(options, required);
        }
        ModifierEntry entry = ModifierEntry.fromJson(json);
        return new EntryMatch(entry);
    }

    public static ModifierMatch read(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        if (size == 1) {
            ModifierEntry entry = ModifierEntry.read(buffer);
            return new EntryMatch(entry);
        }
        int required = buffer.func_150792_a();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)ModifierMatch.read(buffer));
        }
        if (required == 0) {
            return ALWAYS;
        }
        return new ListMatch((List<ModifierMatch>)builder.build(), required);
    }

    public abstract void apply(ModifierNBT.Builder var1);

    public abstract int getMinLevel(Modifier var1);

    public abstract JsonObject serialize();

    public abstract void write(PacketBuffer var1);

    protected static class ListMatch
    extends ModifierMatch {
        protected final List<ModifierMatch> options;
        protected final int required;

        @Override
        public boolean test(List<ModifierEntry> modifiers) {
            int matches = 0;
            for (ModifierMatch match : this.options) {
                if (!match.test(modifiers)) continue;
                ++matches;
            }
            return matches >= this.required;
        }

        @Override
        public int getMinLevel(Modifier modifier) {
            if (this.required == 0 || this.required >= this.options.size()) {
                return 0;
            }
            return this.options.stream().mapToInt(entry -> entry.getMinLevel(modifier)).sorted().skip(this.required - 1).findFirst().orElse(0);
        }

        @Override
        public void apply(ModifierNBT.Builder builder) {
            int max = Math.min(this.required, this.options.size());
            for (int i = 0; i < max; ++i) {
                this.options.get(i).apply(builder);
            }
        }

        @Override
        public JsonObject serialize() {
            if (this.options.size() == 1) {
                return this.options.get(0).serialize();
            }
            JsonArray array = new JsonArray();
            for (ModifierMatch match : this.options) {
                array.add((JsonElement)match.serialize());
            }
            JsonObject json = new JsonObject();
            json.add("options", (JsonElement)array);
            json.addProperty("matches_needed", (Number)this.required);
            return json;
        }

        @Override
        public void write(PacketBuffer buffer) {
            if (this.options.size() == 1) {
                this.options.get(0).write(buffer);
            } else {
                buffer.func_150787_b(this.options.size());
                buffer.func_150787_b(this.required);
                for (ModifierMatch match : this.options) {
                    match.write(buffer);
                }
            }
        }

        public ListMatch(List<ModifierMatch> options, int required) {
            this.options = options;
            this.required = required;
        }
    }

    protected static class EntryMatch
    extends ModifierMatch {
        protected final ModifierEntry entry;

        @Override
        public boolean test(List<ModifierEntry> modifiers) {
            for (ModifierEntry entry : modifiers) {
                if (entry.getModifier() != this.entry.getModifier()) continue;
                return entry.getLevel() >= this.entry.getLevel();
            }
            return false;
        }

        @Override
        public int getMinLevel(Modifier modifier) {
            if (modifier == this.entry.getModifier()) {
                return this.entry.getLevel();
            }
            return 0;
        }

        @Override
        public void apply(ModifierNBT.Builder builder) {
            builder.add(this.entry);
        }

        @Override
        public JsonObject serialize() {
            return this.entry.toJson();
        }

        @Override
        public void write(PacketBuffer buffer) {
            buffer.func_150787_b(1);
            this.entry.write(buffer);
        }

        public EntryMatch(ModifierEntry entry) {
            this.entry = entry;
        }
    }
}

