/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.nbt.IModDataReadOnly;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;

public class ExtraModifier
extends Modifier {
    private final SlotType type;
    private final ModifierSource source;
    private final int slotsPerLevel;

    public ExtraModifier(int color, SlotType type, ModifierSource source, int slotsPerLevel) {
        super(color);
        this.type = type;
        this.source = source;
        this.slotsPerLevel = slotsPerLevel;
    }

    public ExtraModifier(int color, SlotType type, ModifierSource source) {
        this(color, type, source, 1);
    }

    public ExtraModifier(int color) {
        this(color, ExtraType.UPGRADE, ModifierSource.SINGLE_LEVEL);
    }

    @Deprecated
    public ExtraModifier(int color, ExtraType type, ModifierSource source, int slotsPerLevel) {
        this(color, type.getSlotType(), source, slotsPerLevel);
    }

    @Deprecated
    public ExtraModifier(int color, ExtraType type, ModifierSource source) {
        this(color, type, source, 1);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.source.alwaysShow() || advanced;
    }

    @Override
    public void addVolatileData(ToolDefinition toolDefinition, StatsNBT baseStats, IModDataReadOnly persistentData, int level, ModDataNBT data) {
        data.addSlots(this.type, level * this.slotsPerLevel);
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        if (this.source.isSingleLevel() && level == 1) {
            return this.getDisplayName();
        }
        return super.getDisplayName(level);
    }

    @Override
    public int getPriority() {
        return this.source.isSingleLevel() ? 50 : 60;
    }

    @Deprecated
    public static enum ExtraType {
        UPGRADE(SlotType.UPGRADE),
        ABILITY(SlotType.ABILITY),
        TRAIT(SlotType.SOUL);

        private final SlotType slotType;

        private ExtraType(SlotType slotType) {
            this.slotType = slotType;
        }

        public SlotType getSlotType() {
            return this.slotType;
        }
    }

    public static enum ModifierSource {
        SINGLE_LEVEL,
        MULTI_LEVEL,
        TRAIT;


        public boolean isSingleLevel() {
            return this == SINGLE_LEVEL;
        }

        public boolean alwaysShow() {
            return this == TRAIT;
        }
    }
}

