/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public abstract class DurabilityShieldModifier
extends Modifier {
    public DurabilityShieldModifier(int color) {
        super(color);
    }

    @Override
    public ITextComponent getDisplayName(IModifierToolStack tool, int level) {
        return this.getDisplayName(level).func_230532_e_().func_240702_b_(": " + this.getShield(tool) + " / " + this.getShieldCapacity(tool, level));
    }

    @Override
    public ValidatedResult validate(IModifierToolStack tool, int level) {
        if (level > 0) {
            int cap = this.getShieldCapacity(tool, level);
            if (this.getShield(tool) > cap) {
                this.setShield(tool.getPersistentData(), cap);
            }
        }
        return ValidatedResult.PASS;
    }

    @Override
    public void onRemoved(IModifierToolStack tool) {
        tool.getPersistentData().remove(this.getShieldKey());
    }

    @Override
    public int onDamageTool(IModifierToolStack toolStack, int level, int amount) {
        int shield = this.getShield(toolStack);
        if (shield > 0) {
            if (shield >= amount) {
                this.setShield(toolStack, level, shield - amount);
                return 0;
            }
            amount -= shield;
            this.setShield(toolStack, level, 0);
        }
        return amount;
    }

    @Override
    public double getDamagePercentage(IModifierToolStack tool, int level) {
        int shield = this.getShield(tool);
        if (shield > 0) {
            int cap = this.getShieldCapacity(tool, level);
            if (shield > cap) {
                return 0.0;
            }
            return (double)(cap - shield) / (double)cap;
        }
        return Double.NaN;
    }

    protected ResourceLocation getShieldKey() {
        return this.getId();
    }

    protected int getShield(IModifierToolStack tool) {
        return tool.getPersistentData().getInt(this.getShieldKey());
    }

    protected abstract int getShieldCapacity(IModifierToolStack var1, int var2);

    protected void setShield(ModDataNBT persistentData, int amount) {
        persistentData.putInt(this.getShieldKey(), Math.max(amount, 0));
    }

    protected void setShield(IModifierToolStack tool, int level, int amount) {
        this.setShield(tool.getPersistentData(), Math.min(amount, this.getShieldCapacity(tool, level)));
    }

    protected void addShield(IModifierToolStack tool, int level, int amount) {
        this.setShield(tool, level, amount + this.getShield(tool));
    }
}

