/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import org.apache.commons.lang3.mutable.MutableObject;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.client.model.tools.MaterialModel;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;

public class BreakableMaterialModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        RenderMaterial smallTexture = BreakableMaterialModifierModel.stitchMaterialTextures(smallGetter, "");
        RenderMaterial brokenSmall = BreakableMaterialModifierModel.stitchMaterialTextures(smallGetter, "_broken");
        RenderMaterial largeTexture = BreakableMaterialModifierModel.stitchMaterialTextures(largeGetter, "");
        RenderMaterial brokenLarge = BreakableMaterialModifierModel.stitchMaterialTextures(largeGetter, "_broken");
        if (smallTexture != null || brokenSmall != null || largeTexture != null || brokenLarge != null) {
            return new BreakableMaterialModifierModel(smallTexture, brokenSmall, largeTexture, brokenLarge);
        }
        return null;
    };
    private final RenderMaterial[] textures;

    @Nullable
    private static RenderMaterial stitchMaterialTextures(Function<String, RenderMaterial> textureGetter, String name) {
        RenderMaterial baseTexture = textureGetter.apply(name);
        if (baseTexture != null) {
            for (MaterialRenderInfo info : MaterialRenderInfoLoader.INSTANCE.getAllRenderInfos()) {
                ResourceLocation texture = info.getTexture();
                if (texture != null) {
                    textureGetter.apply(name + "_" + MaterialRenderInfo.getSuffix(texture));
                }
                for (String fallback : info.getFallbacks()) {
                    textureGetter.apply(name + "_" + fallback);
                }
            }
        }
        return baseTexture;
    }

    public BreakableMaterialModifierModel(@Nullable RenderMaterial normalSmall, @Nullable RenderMaterial brokenSmall, @Nullable RenderMaterial normalLarge, @Nullable RenderMaterial brokenLarge) {
        this.textures = new RenderMaterial[]{normalSmall, brokenSmall, normalLarge, brokenLarge};
    }

    @Override
    @Nullable
    public Object getCacheKey(IModifierToolStack tool, ModifierEntry entry) {
        Modifier modifier = entry.getModifier();
        return new CacheKey(modifier, tool.getPersistentData().getString(modifier.getId()));
    }

    @Nullable
    private static MaterialId getMaterial(IModifierToolStack tool, Modifier modifier) {
        String material = tool.getPersistentData().getString(modifier.getId());
        if (!material.isEmpty()) {
            return MaterialId.tryCreate(material);
        }
        return null;
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry modifier, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge) {
        return this.getQuads(tool, modifier, spriteGetter, transforms, isLarge, -1, null);
    }

    @Override
    public ImmutableList<BakedQuad> getQuads(IModifierToolStack tool, ModifierEntry modifier, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, TransformationMatrix transforms, boolean isLarge, int startTintIndex, @Nullable ItemLayerPixels pixels) {
        RenderMaterial texture = this.textures[(isLarge ? 2 : 0) | (tool.isBroken() ? 1 : 0)];
        if (texture != null) {
            MutableObject mutable = new MutableObject();
            MaterialModel.getPartQuads(arg_0 -> ((MutableObject)mutable).setValue(arg_0), texture, spriteGetter, transforms, -1, BreakableMaterialModifierModel.getMaterial(tool, modifier.getModifier()), pixels);
            return (ImmutableList)mutable.getValue();
        }
        return ImmutableList.of();
    }

    private static class CacheKey {
        private final Modifier modifier;
        private final String material;

        public CacheKey(Modifier modifier, String material) {
            this.modifier = modifier;
            this.material = material;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public String getMaterial() {
            return this.material;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Modifier this$modifier = this.getModifier();
            Modifier other$modifier = other.getModifier();
            if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
                return false;
            }
            String this$material = this.getMaterial();
            String other$material = other.getMaterial();
            return !(this$material == null ? other$material != null : !this$material.equals(other$material));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Modifier $modifier = this.getModifier();
            result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
            String $material = this.getMaterial();
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            return result;
        }

        public String toString() {
            return "BreakableMaterialModifierModel.CacheKey(modifier=" + this.getModifier() + ", material=" + this.getMaterial() + ")";
        }
    }
}

