/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.tconstruct.library.client.data.GenericTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.util.AbstractSpriteReader;
import slimeknights.tconstruct.library.client.data.util.DataGenSpriteReader;

public class MaterialPartTextureGenerator
extends GenericTextureGenerator {
    public static final String FOLDER = "textures";
    private final DataGenSpriteReader spriteReader;
    private final ExistingFileHelper existingFileHelper;
    private final AbstractPartSpriteProvider partProvider;
    private final AbstractMaterialSpriteProvider[] materialProviders;
    private static final List<IPartTextureCallback> TEXTURE_CALLBACKS = new ArrayList<IPartTextureCallback>();

    public MaterialPartTextureGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper, AbstractPartSpriteProvider spriteProvider, AbstractMaterialSpriteProvider ... materialProviders) {
        super(generator, FOLDER);
        this.spriteReader = new DataGenSpriteReader(existingFileHelper, FOLDER);
        this.existingFileHelper = existingFileHelper;
        this.partProvider = spriteProvider;
        this.materialProviders = materialProviders;
    }

    public String func_200397_b() {
        StringBuilder name = new StringBuilder();
        name.append("Material Part Generator - ");
        name.append(this.partProvider.getName());
        name.append(" - ");
        name.append(this.materialProviders[0].getName());
        for (int i = 1; i < this.materialProviders.length; ++i) {
            name.append(", ").append(this.materialProviders[i].getName());
        }
        return name.toString();
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        MaterialPartTextureGenerator.runCallbacks(this.existingFileHelper, null);
        List<AbstractPartSpriteProvider.PartSpriteInfo> parts = this.partProvider.getSprites();
        if (parts.isEmpty()) {
            throw new IllegalStateException(this.partProvider.getName() + " has no parts, must have at least one part to generate");
        }
        for (AbstractMaterialSpriteProvider materialProvider : this.materialProviders) {
            Collection<AbstractMaterialSpriteProvider.MaterialSpriteInfo> materials = materialProvider.getMaterials().values();
            if (materials.isEmpty()) {
                throw new IllegalStateException(materialProvider.getName() + " has no materials, must have at least one material to generate");
            }
            BiConsumer<ResourceLocation, NativeImage> saver = (path, image) -> this.saveImage(cache, (ResourceLocation)path, (NativeImage)image);
            Predicate<ResourceLocation> shouldGenerate = path -> !this.spriteReader.exists((ResourceLocation)path);
            for (AbstractMaterialSpriteProvider.MaterialSpriteInfo material : materials) {
                for (AbstractPartSpriteProvider.PartSpriteInfo part : parts) {
                    if (!material.supportStatType(part.getStatType())) continue;
                    MaterialPartTextureGenerator.generateSprite(this.spriteReader, material, part, shouldGenerate, saver);
                }
            }
        }
        this.spriteReader.closeAll();
        this.partProvider.cleanCache();
        MaterialPartTextureGenerator.runCallbacks(null, null);
    }

    public static void generateSprite(AbstractSpriteReader spriteReader, AbstractMaterialSpriteProvider.MaterialSpriteInfo material, AbstractPartSpriteProvider.PartSpriteInfo part, Predicate<ResourceLocation> shouldGenerate, BiConsumer<ResourceLocation, NativeImage> saver) {
        ResourceLocation partPath = part.getPath();
        ResourceLocation materialTexture = material.getTexture();
        ResourceLocation spritePath = new ResourceLocation(partPath.func_110624_b(), partPath.func_110623_a() + "_" + materialTexture.func_110624_b() + "_" + materialTexture.func_110623_a());
        if (shouldGenerate.test(spritePath)) {
            String fallback;
            NativeImage base = null;
            String[] stringArray = material.getFallbacks();
            int n = stringArray.length;
            for (int i = 0; i < n && (base = part.getTexture(spriteReader, fallback = stringArray[i])) == null; ++i) {
            }
            if (base == null) {
                base = part.getTexture(spriteReader, "");
            }
            if (base == null) {
                throw new IllegalStateException("Missing sprite at " + partPath + ".png, cannot generate textures");
            }
            NativeImage transformed = material.getTransformer().transformCopy(base);
            spriteReader.track(transformed);
            saver.accept(spritePath, transformed);
        }
    }

    public static void registerCallback(IPartTextureCallback callback) {
        TEXTURE_CALLBACKS.add(callback);
    }

    public static void runCallbacks(@Nullable ExistingFileHelper existingFileHelper, @Nullable IResourceManager manager) {
        for (IPartTextureCallback callback : TEXTURE_CALLBACKS) {
            callback.accept(existingFileHelper, manager);
        }
    }

    public static interface IPartTextureCallback {
        public void accept(@Nullable ExistingFileHelper var1, @Nullable IResourceManager var2);
    }
}

