/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.gadgets.block;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PunjiBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    private static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    private static final BooleanProperty NORTHEAST = BooleanProperty.func_177716_a((String)"northeast");
    private static final BooleanProperty NORTHWEST = BooleanProperty.func_177716_a((String)"northwest");
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final ImmutableMap<Direction, VoxelShape> BOUNDS;

    public PunjiBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTHEAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTHWEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DAMAGE_OTHER;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        Direction direction;
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing == (direction = (Direction)state.func_177229_b((Property)FACING)) && !state.func_196955_c((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Direction north = PunjiBlock.getLocalNorth(direction);
        Direction east = PunjiBlock.getLocalEast(direction);
        if (facing == north) {
            state = (BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, facingPos)));
        } else if (facing == east) {
            state = (BlockState)state.func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, facingPos)));
        }
        BlockPos northPos = pos.func_177972_a(north);
        return (BlockState)((BlockState)state.func_206870_a((Property)NORTHEAST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, northPos.func_177972_a(east))))).func_206870_a((Property)NORTHWEST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, northPos.func_177972_a(east.func_176734_d()))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, NORTH, EAST, NORTHEAST, NORTHWEST, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l().func_176734_d();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
        if (!state.func_196955_c((IWorldReader)world, pos)) {
            return null;
        }
        Direction north = PunjiBlock.getLocalNorth(direction);
        Direction east = PunjiBlock.getLocalEast(direction);
        BlockPos northPos = pos.func_177972_a(north);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, northPos)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, pos.func_177972_a(east))))).func_206870_a((Property)NORTHEAST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, northPos.func_177972_a(east))))).func_206870_a((Property)NORTHWEST, (Comparable)Boolean.valueOf(this.isConnected((IWorldReader)world, direction, northPos.func_177972_a(east.func_176734_d()))))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    private boolean isConnected(IWorldReader world, Direction facing, BlockPos target) {
        BlockState state = world.func_180495_p(target);
        return state.func_177230_c() == this && state.func_177229_b((Property)FACING) == facing;
    }

    private static Direction getLocalNorth(Direction facing) {
        switch (facing) {
            case DOWN: {
                return Direction.NORTH;
            }
            case UP: {
                return Direction.SOUTH;
            }
        }
        return Direction.UP;
    }

    private static Direction getLocalEast(Direction facing) {
        if (facing.func_176740_k() == Direction.Axis.Y) {
            return Direction.EAST;
        }
        return facing.func_176746_e();
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos target = pos.func_177972_a(direction);
        return world.func_180495_p(target).func_224755_d((IBlockReader)world, target, direction.func_176734_d());
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            float damage = 3.0f;
            if (entityIn.field_70143_R > 0.0f) {
                damage += entityIn.field_70143_R * 1.5f + 2.0f;
            }
            entityIn.func_70097_a(DamageSource.field_76367_g, damage);
            ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 1));
        }
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)BOUNDS.get((Object)state.func_177229_b((Property)FACING));
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Direction.DOWN, (Object)VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.375, (double)0.8125));
        builder.put((Object)Direction.UP, (Object)VoxelShapes.func_197873_a((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125));
        builder.put((Object)Direction.NORTH, (Object)VoxelShapes.func_197873_a((double)0.1875, (double)0.1875, (double)0.0, (double)0.8125, (double)0.8125, (double)0.375));
        builder.put((Object)Direction.SOUTH, (Object)VoxelShapes.func_197873_a((double)0.1875, (double)0.1875, (double)0.625, (double)0.8125, (double)0.8125, (double)1.0));
        builder.put((Object)Direction.EAST, (Object)VoxelShapes.func_197873_a((double)0.625, (double)0.1875, (double)0.1875, (double)1.0, (double)0.8125, (double)0.8125));
        builder.put((Object)Direction.WEST, (Object)VoxelShapes.func_197873_a((double)0.0, (double)0.1875, (double)0.1875, (double)0.375, (double)0.8125, (double)0.8125));
        BOUNDS = builder.build();
    }
}

