/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.converter;

import java.util.Optional;
import net.blay09.mods.kleeslabs.converter.SlabConverter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IStringSerializable;

public class SmarterSlabConverter
implements SlabConverter {
    private Block slabBlock;

    public SmarterSlabConverter(Block slabBlock) {
        this.slabBlock = slabBlock;
    }

    @Override
    public BlockState getSingleSlab(BlockState state, SlabType slabType) {
        BlockState newState = this.slabBlock.func_176223_P();
        for (Property property : state.func_235904_r_()) {
            if (property.func_177701_a().equals("half")) {
                newState = this.getHalfBlockState(newState, property, slabType);
                continue;
            }
            newState = this.copyProperty(state, newState, property);
        }
        return newState;
    }

    @Override
    public boolean isDoubleSlab(BlockState state) {
        for (Property property : state.func_235904_r_()) {
            IStringSerializable value;
            if (!property.func_177701_a().equals("half") || !(value = (IStringSerializable)state.func_177229_b(property)).func_176610_l().equals("full")) continue;
            return true;
        }
        return false;
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.func_206870_a(property, sourceState.func_177229_b(property));
    }

    private <T extends Comparable<T>> BlockState getHalfBlockState(BlockState state, Property<T> property, SlabType slabType) {
        Optional parsedValue = Optional.empty();
        if (slabType == SlabType.BOTTOM) {
            parsedValue = property.func_185929_b("bottom");
        } else if (slabType == SlabType.TOP) {
            parsedValue = property.func_185929_b("top");
        }
        return parsedValue.map(t -> (BlockState)state.func_206870_a(property, t)).orElse(state);
    }
}

