/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.darkhax.bookshelf.util.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public final class RenderUtils {
    private static final Random RANDOM = new Random();
    private static final BitSet BITS = new BitSet(3);
    private static final Map<Block, RenderType> RENDER_TYPES = new HashMap<Block, RenderType>();

    public static TextureAtlasSprite getParticleSprite(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
    }

    public TextureAtlasSprite getParticleSprite(BlockState state, World world, BlockPos pos) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().getTexture(state, world, pos);
    }

    public static TextureAtlasSprite getParticleSprite(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static IBakedModel getModel(ModelResourceLocation name) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(name);
    }

    public static IBakedModel getModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static IBakedModel getModel(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
    }

    public static void renderModel(BlockModelRenderer renderer, IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack matrix, IVertexBuilder buffer, Direction[] sides) {
        IModelData modelData = model.getModelData(world, pos, state, (IModelData)EmptyModelData.INSTANCE);
        for (Direction side : sides) {
            RANDOM.setSeed(0L);
            List sidedQuads = model.getQuads(state, side, RANDOM, modelData);
            if (sidedQuads.isEmpty()) continue;
            int lightForSide = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos.func_177972_a(side));
            renderer.func_228798_a_(world, state, pos, lightForSide, OverlayTexture.field_229196_a_, false, matrix, buffer, sidedQuads, BITS);
        }
        RANDOM.setSeed(0L);
        List unsidedQuads = model.getQuads(state, null, RANDOM, modelData);
        if (!unsidedQuads.isEmpty()) {
            renderer.func_228798_a_(world, state, pos, -1, OverlayTexture.field_229196_a_, true, matrix, buffer, unsidedQuads, BITS);
        }
    }

    public static String getName(RenderState state) {
        return state.field_228509_a_;
    }

    public static RenderType getRenderType(BlockState state) {
        return RENDER_TYPES.computeIfAbsent(state.func_177230_c(), k -> RenderUtils.findRenderType(state));
    }

    public static RenderType findRenderType(BlockState state) {
        for (RenderType blockType : RenderType.func_228661_n_()) {
            if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)blockType)) continue;
            return blockType;
        }
        return RenderTypeLookup.func_239221_b_((BlockState)state);
    }

    public static void renderState(BlockState state, World world, BlockPos pos, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay, boolean withFluid, Direction ... preferredSides) {
        FluidState fluidState;
        if (!ModUtils.isOptifineLoaded()) {
            RenderUtils.renderBlock(state, world, pos, matrix, buffer, preferredSides);
        } else {
            RenderUtils.renderBlock(state, world, pos, matrix, buffer);
        }
        if (withFluid && (fluidState = state.func_204520_s()) != null && !fluidState.func_206888_e()) {
            Fluid fluid = fluidState.func_206886_c();
            ResourceLocation texture = fluid.getAttributes().getStillTexture();
            int[] color = RenderUtils.unpackColor(fluid.getAttributes().getColor((IBlockDisplayReader)world, pos));
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(texture);
            RenderUtils.renderBlockSprite(buffer.getBuffer(RenderType.func_228645_f_()), matrix, sprite, light, overlay, color);
        }
    }

    private static void renderBlock(BlockState state, World world, BlockPos pos, MatrixStack matrix, IRenderTypeBuffer buffer, Direction[] renderSides) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(state);
        RenderType type = RenderUtils.findRenderType(state);
        if (type != null) {
            ForgeHooksClient.setRenderLayer((RenderType)type);
            IVertexBuilder builder = buffer.getBuffer(type);
            RenderUtils.renderModel(dispatcher.func_175019_b(), (IBlockDisplayReader)world, model, state, pos, matrix, builder, renderSides);
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    private static void renderBlock(BlockState state, World world, BlockPos pos, MatrixStack matrix, IRenderTypeBuffer buffer) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = dispatcher.func_184389_a(state);
        boolean useAO = Minecraft.func_71379_u() && state.getLightValue((IBlockReader)world, pos) == 0 && model.func_177555_b();
        RenderType type = RenderUtils.findRenderType(state);
        if (type != null) {
            ForgeHooksClient.setRenderLayer((RenderType)type);
            IVertexBuilder builder = buffer.getBuffer(type);
            RenderUtils.renderModel(dispatcher.func_175019_b(), useAO, (IBlockDisplayReader)world, model, state, pos, matrix, builder, false, OverlayTexture.field_229196_a_);
            ForgeHooksClient.setRenderLayer(null);
        }
    }

    private static boolean renderModel(BlockModelRenderer renderer, boolean useAO, IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack matrix, IVertexBuilder buffer, boolean checkSides, int overlay) {
        try {
            IModelData modelData = model.getModelData(world, pos, state, (IModelData)EmptyModelData.INSTANCE);
            return useAO ? renderer.renderModelSmooth(world, model, state, pos, matrix, buffer, checkSides, RANDOM, 0L, overlay, modelData) : renderer.renderModelFlat(world, model, state, pos, matrix, buffer, checkSides, RANDOM, 0L, overlay, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (BlockState)state);
            crashreportcategory.func_71507_a("Using AO", (Object)useAO);
            throw new ReportedException(crashreport);
        }
    }

    public static void renderLinesWrapped(MatrixStack matrix, int x, int y, ITextComponent text, int textWidth) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.getClass();
        RenderUtils.renderLinesWrapped(matrix, font, x, y, 9, 0, text, textWidth);
    }

    public static void renderLinesWrapped(MatrixStack matrix, FontRenderer fontRenderer, int x, int y, int spacing, int defaultColor, ITextComponent text, int textWidth) {
        RenderUtils.renderLinesWrapped(matrix, fontRenderer, x, y, spacing, defaultColor, fontRenderer.func_238425_b_((ITextProperties)text, textWidth));
    }

    public static void renderLinesWrapped(MatrixStack matrix, FontRenderer fontRenderer, int x, int y, int spacing, int defaultColor, List<IReorderingProcessor> lines) {
        for (int lineNum = 0; lineNum < lines.size(); ++lineNum) {
            IReorderingProcessor lineFragment = lines.get(lineNum);
            fontRenderer.func_238422_b_(matrix, lineFragment, (float)x, (float)(y + lineNum * spacing), defaultColor);
        }
    }

    public static int renderLinesReversed(MatrixStack matrix, int x, int y, ITextComponent text, int textWidth) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.getClass();
        return RenderUtils.renderLinesReversed(matrix, font, x, y, 9, 0xFFFFFF, text, textWidth);
    }

    public static int renderLinesReversed(MatrixStack matrix, FontRenderer fontRenderer, int x, int y, int spacing, int defaultColor, ITextComponent text, int textWidth) {
        return RenderUtils.renderLinesReversed(matrix, fontRenderer, x, y, spacing, defaultColor, fontRenderer.func_238425_b_((ITextProperties)text, textWidth));
    }

    public static int renderLinesReversed(MatrixStack matrix, FontRenderer fontRenderer, int x, int y, int spacing, int defaultColor, List<IReorderingProcessor> lines) {
        int lineCount = lines.size();
        for (int lineNum = lineCount - 1; lineNum >= 0; --lineNum) {
            IReorderingProcessor lineFragment = lines.get(lineCount - 1 - lineNum);
            fontRenderer.func_238422_b_(matrix, lineFragment, (float)x, (float)(y - (lineNum + 1) * (spacing + 1)), defaultColor);
        }
        return lineCount * (spacing + 1);
    }

    public static int[] unpackColor(int color) {
        int[] colors = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    public static void renderBlockSprite(IVertexBuilder builder, MatrixStack stack, TextureAtlasSprite sprite, int light, int overlay, int[] color) {
        RenderUtils.renderBlockSprite(builder, stack.func_227866_c_().func_227870_a_(), sprite, light, overlay, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, color);
    }

    public static void renderBlockSprite(IVertexBuilder builder, MatrixStack stack, TextureAtlasSprite sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        RenderUtils.renderBlockSprite(builder, stack.func_227866_c_().func_227870_a_(), sprite, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    public static void renderBlockSprite(IVertexBuilder builder, Matrix4f pos, TextureAtlasSprite sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.DOWN, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.UP, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.NORTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.SOUTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.WEST, light, overlay, x1, x2, y1, y2, z1, z2, color);
        RenderUtils.renderSpriteSide(builder, pos, sprite, Direction.EAST, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    public static void renderSpriteSide(IVertexBuilder builder, Matrix4f pos, TextureAtlasSprite sprite, Direction side, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        float v2;
        float v1;
        float u2;
        float u1;
        double px1 = x1 * 16.0f;
        double px2 = x2 * 16.0f;
        double py1 = y1 * 16.0f;
        double py2 = y2 * 16.0f;
        double pz1 = z1 * 16.0f;
        double pz2 = z2 * 16.0f;
        if (side == Direction.DOWN) {
            u1 = sprite.func_94214_a(px1);
            u2 = sprite.func_94214_a(px2);
            v1 = sprite.func_94207_b(pz1);
            v2 = sprite.func_94207_b(pz2);
            builder.func_227888_a_(pos, x1, y1, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y1, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y1, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y1, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        if (side == Direction.UP) {
            u1 = sprite.func_94214_a(px1);
            u2 = sprite.func_94214_a(px2);
            v1 = sprite.func_94207_b(pz1);
            v2 = sprite.func_94207_b(pz2);
            builder.func_227888_a_(pos, x1, y2, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y2, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y2, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y2, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        }
        if (side == Direction.NORTH) {
            u1 = sprite.func_94214_a(px1);
            u2 = sprite.func_94214_a(px2);
            v1 = sprite.func_94207_b(py1);
            v2 = sprite.func_94207_b(py2);
            builder.func_227888_a_(pos, x1, y1, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y2, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y2, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y1, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        }
        if (side == Direction.SOUTH) {
            u1 = sprite.func_94214_a(px1);
            u2 = sprite.func_94214_a(px2);
            v1 = sprite.func_94207_b(py1);
            v2 = sprite.func_94207_b(py2);
            builder.func_227888_a_(pos, x2, y1, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y2, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y2, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y1, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        }
        if (side == Direction.WEST) {
            u1 = sprite.func_94214_a(py1);
            u2 = sprite.func_94214_a(py2);
            v1 = sprite.func_94207_b(pz1);
            v2 = sprite.func_94207_b(pz2);
            builder.func_227888_a_(pos, x1, y1, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y2, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y2, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x1, y1, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        }
        if (side == Direction.EAST) {
            u1 = sprite.func_94214_a(py1);
            u2 = sprite.func_94214_a(py2);
            v1 = sprite.func_94207_b(pz1);
            v2 = sprite.func_94207_b(pz2);
            builder.func_227888_a_(pos, x2, y1, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y2, z1).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v1).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y2, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u2, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
            builder.func_227888_a_(pos, x2, y1, z2).func_225586_a_(color[1], color[2], color[3], color[0]).func_225583_a_(u1, v2).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        }
    }
}

