/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.modifier;

import com.google.gson.JsonObject;
import java.util.List;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class ModifierConvert
extends LootModifier {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation tableName;
    private final float chance;

    public ModifierConvert(ILootCondition[] conditions, ResourceLocation table, float chance) {
        super(conditions);
        this.tableName = table;
        this.chance = chance;
    }

    protected List<ItemStack> doApply(List<ItemStack> loot, LootContext ctx) {
        NonNullList outputs = NonNullList.func_191196_a();
        LootTable table = ctx.func_202879_g().func_73046_m().func_200249_aQ().func_186521_a(this.tableName);
        for (ItemStack item : loot) {
            if (MathsUtils.tryPercentage(this.chance)) {
                outputs.addAll(table.func_216113_a(ctx));
                continue;
            }
            outputs.add(item);
        }
        return outputs;
    }

    static class Serializer
    extends GlobalLootModifierSerializer<ModifierConvert> {
        Serializer() {
        }

        public ModifierConvert read(ResourceLocation location, JsonObject data, ILootCondition[] conditions) {
            ResourceLocation tableName = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)data, (String)"table"));
            float chance = JSONUtils.func_151221_a((JsonObject)data, (String)"chance", (float)1.0f);
            return new ModifierConvert(conditions, tableName, chance);
        }

        public JsonObject write(ModifierConvert instance) {
            JsonObject json = new JsonObject();
            json.addProperty("table", instance.tableName.toString());
            if (instance.chance > 0.0f) {
                json.addProperty("chance", (Number)Float.valueOf(instance.chance));
            }
            return json;
        }
    }
}

