/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.item;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StackList;
import net.minecraftforge.registries.ForgeRegistries;

public class IngredientModid
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();
    private final String modid;

    private IngredientModid(String modid, Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
        this.modid = modid;
    }

    public boolean test(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b().getRegistryName().func_110624_b().equals(this.modid);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<IngredientModid> getSerializer() {
        return SERIALIZER;
    }

    static class Serializer
    implements IIngredientSerializer<IngredientModid> {
        Serializer() {
        }

        public IngredientModid parse(PacketBuffer buffer) {
            String modid = buffer.func_218666_n();
            return new IngredientModid(modid, Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        public IngredientModid parse(JsonObject json) {
            String modid = JSONUtils.func_151200_h((JsonObject)json, (String)"modid");
            return new IngredientModid(modid, Stream.of(new StackList(this.getMatchingItems(modid))));
        }

        public void write(PacketBuffer buffer, IngredientModid ingredient) {
            buffer.func_180714_a(ingredient.modid);
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }

        private List<ItemStack> getMatchingItems(String modid) {
            NonNullList matchingItems = NonNullList.func_191196_a();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!item.getRegistryName().func_110624_b().equals(modid)) continue;
                matchingItems.add(new ItemStack((IItemProvider)item));
            }
            return matchingItems;
        }
    }
}

