/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.util;

import chanceCubes.config.CCubesSettings;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class RewardBlockCache {
    protected List<StoredBlockData> storedBlocks = new ArrayList<StoredBlockData>();
    protected Map<BlockPos, CompoundNBT> storedTE = new HashMap<BlockPos, CompoundNBT>();
    private BlockPos origin;
    private BlockPos playerloc;
    private World world;
    private boolean force = true;

    public RewardBlockCache(World world, BlockPos pos, BlockPos playerloc) {
        this.world = world;
        this.origin = pos;
        this.playerloc = playerloc;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void cacheBlock(BlockPos offset, BlockState newState) {
        this.cacheBlock(offset, newState, 3);
    }

    public void cacheBlock(BlockPos offset, BlockState newState, int update) {
        BlockPos adjPos = this.origin.func_177971_a((Vector3i)offset);
        BlockState oldState = this.world.func_180495_p(adjPos);
        CompoundNBT oldNBT = null;
        TileEntity te = this.world.func_175625_s(adjPos);
        if (te != null) {
            oldNBT = te.serializeNBT();
            if (te instanceof IInventory) {
                ((IInventory)te).func_174888_l();
            }
        }
        if (RewardsUtil.placeBlock(newState, this.world, adjPos, update, this.force) && this.storedBlocks.stream().noneMatch(t -> t.pos.equals((Object)offset))) {
            this.storedBlocks.add(new StoredBlockData(offset, oldState, newState));
            if (oldNBT != null) {
                this.storedTE.put(offset, oldNBT);
            }
        }
    }

    public void restoreBlocks(Entity player) {
        List blockedRestoreBlocks = (List)CCubesSettings.blockRestoreBlacklist.get();
        for (StoredBlockData storedBlock : this.storedBlocks) {
            BlockPos worldPos = this.origin.func_177971_a((Vector3i)storedBlock.pos);
            ResourceLocation res = this.world.func_180495_p(worldPos).func_177230_c().getRegistryName();
            if (res != null && blockedRestoreBlocks.contains(res.toString())) continue;
            RewardsUtil.placeBlock(storedBlock.oldState, this.world, worldPos, true);
            TileEntity tile = this.world.func_175625_s(worldPos);
            if (!this.storedTE.containsKey(storedBlock.pos) || tile == null) continue;
            tile.deserializeNBT(storedBlock.oldState, this.storedTE.get(storedBlock.pos));
        }
        if (player != null) {
            player.func_70634_a((double)this.playerloc.func_177958_n() + 0.5, (double)this.playerloc.func_177956_o(), (double)this.playerloc.func_177952_p() + 0.5);
        }
    }

    private static class StoredBlockData {
        public BlockPos pos;
        public BlockState oldState;
        public BlockState placedState;

        public StoredBlockData(BlockPos pos, BlockState oldState, BlockState placedState) {
            this.pos = pos;
            this.oldState = oldState;
            this.placedState = placedState;
        }
    }
}

