/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.tileentities;

import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.sounds.CCubesSounds;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileChanceD20
extends TileEntity
implements ITickableTileEntity {
    public static final ModelProperty<D20AnimationWrapper> D20AnimationProperty = new ModelProperty();
    private static final Random random = new Random();
    private boolean breaking = false;
    private int stage = 0;
    public float rotation = 0.0f;
    public float wave = 0.0f;
    private PlayerEntity player;
    private int chance;
    private boolean isScanned = false;
    private D20AnimationWrapper animationWrapper = new D20AnimationWrapper();

    public TileChanceD20() {
        super(CCubesBlocks.TILE_CHANCE_ICOSAHEDRON);
        if (!((Boolean)CCubesSettings.d20UseNormalChances.get()).booleanValue()) {
            this.chance = random.nextBoolean() ? -100 : 100;
        } else {
            this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            while (this.chance > 100 || this.chance < -100) {
                this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            }
        }
    }

    public TileChanceD20(int initialChance) {
        super(CCubesBlocks.TILE_CHANCE_ICOSAHEDRON);
        this.chance = initialChance;
    }

    public void setChance(int newChance) {
        this.chance = newChance;
    }

    public int getChance() {
        return this.chance;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("chance", this.getChance());
        nbt = super.func_189515_b(nbt);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.chance = nbt.func_74762_e("chance");
    }

    public void func_73660_a() {
        if (this.breaking) {
            ++this.stage;
        }
        if (this.stage > 200) {
            this.breaking = false;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                this.field_145850_b.func_175713_t(this.field_174879_c);
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward((ServerWorld)this.field_145850_b, this.field_174879_c, this.player, this.getChance());
            }
        } else if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            Quaternion yaw = new Quaternion(0.0f, 1.0f, 0.0f, (float)(Math.toRadians((float)this.field_145850_b.func_82737_E() % 10000.0f / 10000.0f * 360.0f) + (0.4 + Math.pow(1.02, this.getStage() + 1))));
            Quaternion pitch = new Quaternion(1.0f, 0.0f, 0.0f, 0.0f);
            this.animationWrapper.transform = new Vector3f(0.5f, 0.5f + this.wave * 0.15f, 0.5f);
            this.animationWrapper.rot = yaw;
            this.field_145850_b.func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        }
    }

    public void startBreaking(PlayerEntity player) {
        if (!this.breaking) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), CCubesSounds.D20_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.player = player;
            }
            this.breaking = true;
            this.stage = 0;
        }
    }

    public int getStage() {
        return this.stage;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT syncData = new CompoundNBT();
        syncData = this.func_189515_b(syncData);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public boolean isScanned() {
        return this.isScanned;
    }

    public void setScanned(boolean isScanned) {
        this.isScanned = isScanned;
    }

    @Nonnull
    public IModelData getModelData() {
        IModelData modelData = super.getModelData();
        return modelData;
    }

    public static class D20AnimationWrapper {
        public Vector3f transform;
        public Quaternion rot;
    }
}

