/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.config.ConfigLoader;
import chanceCubes.registry.global.GlobalCCRewardRegistry;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardtype.BlockRewardType;
import chanceCubes.rewards.rewardtype.EntityRewardType;
import chanceCubes.rewards.rewardtype.ItemRewardType;
import chanceCubes.rewards.rewardtype.MessageRewardType;
import chanceCubes.util.RewardBlockCache;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WheelSpinReward
extends BaseCustomReward {
    private static final List<RewardTrigger> rewards = new ArrayList<RewardTrigger>();
    private RewardTrigger[] rewardsChosen = new RewardTrigger[4];

    public WheelSpinReward() {
        super("chancecubes:wheel_spin", 10);
    }

    @Override
    public void trigger(final ServerWorld world, final BlockPos pos, final PlayerEntity player, JsonObject settings) {
        int i;
        String[] textToSet;
        SignTileEntity sign;
        final ArmorStandEntity armorStand = (ArmorStandEntity)EntityType.field_200789_c.func_200721_a((World)world);
        armorStand.func_70080_a((double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + 1.15, (double)pos.func_177952_p() + 1.5, 0.0f, 0.0f);
        armorStand.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_196192_eh));
        armorStand.func_175428_d(new Rotations(90.0f, 0.0f, 0.0f));
        armorStand.func_82142_c(true);
        armorStand.func_189654_d(true);
        world.func_217376_c((Entity)armorStand);
        this.rewardsChosen[0] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        this.rewardsChosen[1] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        this.rewardsChosen[2] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        this.rewardsChosen[3] = rewards.get(RewardsUtil.rand.nextInt(rewards.size()));
        final RewardBlockCache cache = new RewardBlockCache((World)world, pos, player.func_233580_cy_());
        BlockState bc = Blocks.field_196858_iR.func_176223_P();
        BlockState wc = Blocks.field_196828_iC.func_176223_P();
        BlockState lbc = Blocks.field_196834_iF.func_176223_P();
        BlockState ss = (BlockState)Blocks.field_222392_ch.func_176223_P().func_206870_a((Property)WallSignBlock.field_176412_a, (Comparable)Direction.SOUTH);
        BlockPos offset = new BlockPos(0, 0, 1);
        cache.cacheBlock(offset, ss);
        TileEntity tileEntity = world.func_175625_s(pos.func_177971_a((Vector3i)offset));
        if (tileEntity instanceof SignTileEntity) {
            sign = (SignTileEntity)tileEntity;
            textToSet = this.rewardsChosen[0].signText;
            for (i = 0; i < textToSet.length; ++i) {
                sign.func_212365_a(i, (ITextComponent)new StringTextComponent(textToSet[i]));
            }
        }
        offset = new BlockPos(-2, 2, 1);
        cache.cacheBlock(offset, ss);
        tileEntity = world.func_175625_s(pos.func_177971_a((Vector3i)offset));
        if (tileEntity instanceof SignTileEntity) {
            sign = (SignTileEntity)tileEntity;
            textToSet = this.rewardsChosen[1].signText;
            for (i = 0; i < textToSet.length; ++i) {
                sign.func_212365_a(i, (ITextComponent)new StringTextComponent(textToSet[i]));
            }
        }
        offset = new BlockPos(2, 2, 1);
        cache.cacheBlock(offset, ss);
        tileEntity = world.func_175625_s(pos.func_177971_a((Vector3i)offset));
        if (tileEntity instanceof SignTileEntity) {
            sign = (SignTileEntity)tileEntity;
            textToSet = this.rewardsChosen[3].signText;
            for (i = 0; i < textToSet.length; ++i) {
                sign.func_212365_a(i, (ITextComponent)new StringTextComponent(textToSet[i]));
            }
        }
        offset = new BlockPos(0, 4, 1);
        cache.cacheBlock(offset, ss);
        tileEntity = world.func_175625_s(pos.func_177971_a((Vector3i)offset));
        if (tileEntity instanceof SignTileEntity) {
            sign = (SignTileEntity)tileEntity;
            textToSet = this.rewardsChosen[2].signText;
            for (i = 0; i < textToSet.length; ++i) {
                sign.func_212365_a(i, (ITextComponent)new StringTextComponent(textToSet[i]));
            }
        }
        offset = new BlockPos(4, 1, 1);
        cache.cacheBlock(offset, ss);
        tileEntity = world.func_175625_s(pos.func_177971_a((Vector3i)offset));
        if (tileEntity instanceof SignTileEntity) {
            sign = (SignTileEntity)tileEntity;
            sign.func_212365_a(0, (ITextComponent)new StringTextComponent("Pull"));
            sign.func_212365_a(1, (ITextComponent)new StringTextComponent("To Spin"));
            sign.func_212365_a(2, (ITextComponent)new StringTextComponent("The Wheel!"));
        }
        final BlockPos leverOffset = new BlockPos(4, 0, 1);
        cache.cacheBlock(leverOffset, (BlockState)Blocks.field_150442_at.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.SOUTH));
        cache.cacheBlock(new BlockPos(4, 1, 0), wc);
        cache.cacheBlock(new BlockPos(4, 0, 0), wc);
        cache.cacheBlock(new BlockPos(-1, 4, 0), bc);
        cache.cacheBlock(new BlockPos(0, 4, 0), bc);
        cache.cacheBlock(new BlockPos(1, 4, 0), bc);
        cache.cacheBlock(new BlockPos(-2, 3, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 3, 0), bc);
        cache.cacheBlock(new BlockPos(0, 3, 0), bc);
        cache.cacheBlock(new BlockPos(1, 3, 0), lbc);
        cache.cacheBlock(new BlockPos(2, 3, 0), lbc);
        cache.cacheBlock(new BlockPos(-2, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(0, 2, 0), wc);
        cache.cacheBlock(new BlockPos(1, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(2, 2, 0), lbc);
        cache.cacheBlock(new BlockPos(-2, 1, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 1, 0), lbc);
        cache.cacheBlock(new BlockPos(0, 1, 0), bc);
        cache.cacheBlock(new BlockPos(1, 1, 0), bc);
        cache.cacheBlock(new BlockPos(2, 1, 0), lbc);
        cache.cacheBlock(new BlockPos(-1, 0, 0), bc);
        cache.cacheBlock(new BlockPos(0, 0, 0), bc);
        cache.cacheBlock(new BlockPos(1, 0, 0), bc);
        Scheduler.scheduleTask(new Task("wheel_spin_lever_task", 600, 1){
            BlockPos leverPos;
            {
                super(name, delay, updateTick);
                this.leverPos = pos.func_177971_a((Vector3i)leverOffset);
            }

            @Override
            public void callback() {
                cache.restoreBlocks(null);
                armorStand.func_70106_y();
            }

            @Override
            public void update() {
                BlockState state = world.func_180495_p(this.leverPos);
                if (!state.func_177230_c().equals(Blocks.field_150442_at)) {
                    world.func_175656_a(this.leverPos, Blocks.field_150442_at.func_176223_P());
                } else if (((Boolean)state.func_177229_b((Property)LeverBlock.field_176359_b)).booleanValue()) {
                    WheelSpinReward.this.spinWheel(world, pos, armorStand, cache, player);
                    Scheduler.removeTask(this);
                }
            }
        });
    }

    public void spinWheel(final ServerWorld world, final BlockPos pos, final ArmorStandEntity armorStand, final RewardBlockCache cache, final PlayerEntity player) {
        final int rewardPicked = RewardsUtil.rand.nextInt(4);
        int delayBase = 194 + rewardPicked * 6 - 1;
        Scheduler.scheduleTask(new Task("wheel_spin_task", delayBase, 1){
            float rotIndex;
            {
                super(name, delay, updateTick);
                this.rotIndex = 0.0f;
            }

            @Override
            public void callback() {
                WheelSpinReward.this.endDelay(world, pos, armorStand, cache, player, rewardPicked);
            }

            @Override
            public void update() {
                this.rotIndex += 15.0f;
                armorStand.func_175428_d(new Rotations(90.0f, 0.0f, this.rotIndex));
                if (this.rotIndex % 30.0f == 0.0f) {
                    world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
        });
    }

    public void endDelay(final ServerWorld world, final BlockPos pos, final ArmorStandEntity armorStand, final RewardBlockCache cache, final PlayerEntity player, final int rewardPicked) {
        Scheduler.scheduleTask(new Task("wheel_spin_end_task", 60){

            @Override
            public void callback() {
                armorStand.func_70106_y();
                cache.restoreBlocks((Entity)player);
                BaseCustomReward reward = ((WheelSpinReward)WheelSpinReward.this).rewardsChosen[rewardPicked].reward;
                JsonObject settingsJson = ConfigLoader.getRewardSettings(reward.getName());
                reward.trigger(world, pos, player, settingsJson);
            }
        });
    }

    static {
        rewards.add(new RewardTrigger(new BasicReward("diamond", 0, new ItemRewardType(new ItemPart(new ItemStack((IItemProvider)Items.field_151045_i, 1)))), "", "1 Diamond"));
        rewards.add(new RewardTrigger(new BasicReward("creeper", 0, new EntityRewardType("creeper")), "", "Creeper"));
        rewards.add(new RewardTrigger(new BaseCustomReward("tnt", 0){

            @Override
            public void trigger(ServerWorld world, BlockPos pos, PlayerEntity player, JsonObject settings) {
                for (int i = 0; i < 5; ++i) {
                    TNTEntity entitytntprimed = new TNTEntity((World)world, player.func_226277_ct_(), player.func_226278_cu_() + 1.0, player.func_226281_cx_(), (LivingEntity)player);
                    world.func_217376_c((Entity)entitytntprimed);
                    world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    entitytntprimed.func_184534_a(140);
                }
            }
        }, "", "TNT"));
        rewards.add(new RewardTrigger(new BasicReward("diamond_cooking", 0, new ItemRewardType(new ItemPart(new ItemStack((IItemProvider)Items.field_221896_ff, 1))), new MessageRewardType("Sorry, your diamond wasn't done cooking! :(")), "", "1 Diamond?"));
        rewards.add(new RewardTrigger(new BaseCustomReward("random_reward_neutral", 0){

            @Override
            public void trigger(ServerWorld world, BlockPos pos, PlayerEntity player, JsonObject settings) {
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward(world, pos, player, 0);
            }
        }, "Random", "chance Cube", "Reward", "Value: 0"));
        rewards.add(new RewardTrigger(new BaseCustomReward("random_reward_bad", 0){

            @Override
            public void trigger(ServerWorld world, BlockPos pos, PlayerEntity player, JsonObject settings) {
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward(world, pos, player, -50);
            }
        }, "Random", "chance Cube", "Reward", "Value: -50"));
        rewards.add(new RewardTrigger(new BaseCustomReward("random_reward_good", 0){

            @Override
            public void trigger(ServerWorld world, BlockPos pos, PlayerEntity player, JsonObject settings) {
                GlobalCCRewardRegistry.DEFAULT.triggerRandomReward(world, pos, player, 50);
            }
        }, "Random", "chance Cube", "Reward", "Value: 50"));
        rewards.add(new RewardTrigger(new BasicReward("emerald", 0, new ItemRewardType(new ItemPart(new ItemStack((IItemProvider)Items.field_151166_bC, 1)))), "", "1 Emerald"));
        rewards.add(new RewardTrigger(new BasicReward("nothing", 0, new MessageRewardType("Congrats! You won absolutely nothing!")), "", "Nothing"));
        ItemStack car = new ItemStack((IItemProvider)Items.field_151143_au);
        car.func_200302_a((ITextComponent)new StringTextComponent("New Car!"));
        car.func_77966_a(Enchantments.field_185307_s, 0);
        rewards.add(new RewardTrigger(new BasicReward("new_car", 0, new ItemRewardType(new ItemPart(car))), "", "A Brand", "New Car"));
        rewards.add(new RewardTrigger(new BasicReward("lava", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150353_l, false))), "", "Hot Stuff"));
        rewards.add(new RewardTrigger(new BaseCustomReward("vacation", 0){

            @Override
            public void trigger(ServerWorld world, BlockPos pos, PlayerEntity player, JsonObject settings) {
                int xChange = world.field_73012_v.nextInt(50) + 20 + pos.func_177958_n() - 35;
                int zChange = world.field_73012_v.nextInt(50) + 20 + pos.func_177952_p() - 35;
                int yChange = -1;
                for (int yy = 0; yy <= world.func_217301_I(); ++yy) {
                    if (!world.func_175623_d(new BlockPos(xChange, yy, zChange)) || !world.func_175623_d(new BlockPos(xChange, yy + 1, zChange))) continue;
                    yChange = yy;
                    break;
                }
                if (yChange == -1) {
                    return;
                }
                player.func_70634_a((double)xChange, (double)yChange, (double)zChange);
            }
        }, "All", "Expenses", "Paid", "Vacation"));
        rewards.add(new RewardTrigger(new BasicReward("free_groceries", 0, new ItemRewardType(new ItemPart(new ItemStack((IItemProvider)Items.field_151025_P, 64)), new ItemPart(new ItemStack((IItemProvider)Items.field_151106_aX, 64)), new ItemPart(new ItemStack((IItemProvider)Items.field_151117_aB, 10))), new MessageRewardType("There, that should last you a year!")), "", "Free Groceries", "For a YEAR!"));
    }

    private static class RewardTrigger {
        public String[] signText;
        public BaseCustomReward reward;

        public RewardTrigger(BaseCustomReward reward, String ... lines) {
            this.reward = reward;
            this.signText = lines;
        }
    }
}

