/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageSource;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuestionsReward
extends BaseCustomReward {
    private Map<PlayerEntity, String> inQuestion = new HashMap<PlayerEntity, String>();
    private List<CustomEntry<String, String>> questionsAndAnswers = new ArrayList<CustomEntry<String, String>>();

    public QuestionsReward() {
        super("chancecubes:question", -30);
        this.addQuestionAnswer("What is the username of the creator of Chance Cubes?", "Turkey -or- Turkey2349 -or- TurkeyDev");
        this.addQuestionAnswer("How many sides does the sparkly, shiny, colorful, spinny Chance Cube have?", "20");
        this.addQuestionAnswer("What is 9 + 10", "19 -or- 21");
        this.addQuestionAnswer("What year was minecraft officially released", "2011");
        this.addQuestionAnswer("What company developes Java?", "Sun -or- Sun Microsystems -or- Oracle");
        this.addQuestionAnswer("Who created Minecraft?", "Notch");
    }

    public void addQuestionAnswer(String q, String a) {
        this.questionsAndAnswers.add(new CustomEntry<String, String>(q, a));
    }

    @Override
    public void trigger(ServerWorld world, BlockPos pos, final PlayerEntity player, JsonObject settings) {
        if (this.inQuestion.containsKey(player)) {
            return;
        }
        if (!RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        int question = world.field_73012_v.nextInt(this.questionsAndAnswers.size());
        RewardsUtil.sendMessageToPlayer(player, this.questionsAndAnswers.get(question).getKey());
        RewardsUtil.sendMessageToPlayer(player, "You have 20 seconds to answer! (Answer is not case sensitive)");
        this.inQuestion.put(player, this.questionsAndAnswers.get(question).getValue());
        Scheduler.scheduleTask(new Task("Question", 400, 20){

            @Override
            public void callback() {
                QuestionsReward.this.timeUp(player, false);
            }

            @Override
            public void update() {
                if (!QuestionsReward.this.inQuestion.containsKey(player)) {
                    Scheduler.removeTask(this);
                }
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, STitlePacket.Type.ACTIONBAR);
                }
            }
        });
    }

    private void timeUp(PlayerEntity player, boolean correct) {
        if (!this.inQuestion.containsKey(player)) {
            return;
        }
        if (correct) {
            RewardsUtil.sendMessageToPlayer(player, "Correct!");
            RewardsUtil.sendMessageToPlayer(player, "Here, have a item!");
            player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)RewardsUtil.getRandomItem(), 1)));
        } else {
            RewardsUtil.sendMessageToPlayer(player, "Incorrect! The answer was " + this.inQuestion.get(player));
            player.field_70170_p.func_217385_a((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 1.0f, Explosion.Mode.NONE);
            player.func_70097_a((DamageSource)CCubesDamageSource.QUESTION_FAIL, Float.MAX_VALUE);
        }
        this.inQuestion.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        ServerPlayerEntity player = event.getPlayer();
        if (this.inQuestion.containsKey(player)) {
            String answer = event.getMessage();
            boolean correct = false;
            for (String s : this.inQuestion.get(player).split("-or-")) {
                if (!s.trim().equalsIgnoreCase(answer.trim())) continue;
                correct = true;
                break;
            }
            this.timeUp((PlayerEntity)player, correct);
            event.setCanceled(true);
        }
    }
}

